package org.openliberty.xmltooling.idsis.dap;


import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.dst2_1.DataResponseBaseType;
import org.openliberty.xmltooling.dst2_1.TestResult;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.openliberty.xmltooling.utility_2_0.ResponseType;
import org.openliberty.xmltooling.utility_2_0.Status;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * 
 * 
 * builder {@link DAPQueryResponseBuilder}
 * unmarshaller {@link DAPQueryResponseUnmarshaller}
 * <pre>
  <xs:complexType name="QueryResponseType">
    <xs:complexContent>
      <xs:extension base="dst:DataResponseBaseType">
        <xs:sequence>
          <xs:element ref="dst:TestResult"  minOccurs="0" maxOccurs="unbounded"/>
          <xs:element ref="dap:Data"    minOccurs="0" maxOccurs="unbounded"/>
        </xs:sequence>
      </xs:extension>
    </xs:complexContent>
  </xs:complexType>
 * </pre>
 * 
 * @author asa
 *
 */
public class DAPQueryResponse extends DataResponseBaseType
{
    // private static final Logger log = Logger.getLogger(DAPQueryResponse.class);
        
    private XMLObjectChildrenList<TestResult> testResults;
    private XMLObjectChildrenList<DAPData> dataList;
    
    public DAPQueryResponse(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    
    public XMLObjectChildrenList<DAPData> getDAPDatas()
    {
        if(null==dataList) dataList = new XMLObjectChildrenList<DAPData>(this);
        return dataList;
    }
    
    public XMLObjectChildrenList<TestResult> getTestResults()
    {
        if(null==testResults) testResults = new XMLObjectChildrenList<TestResult>(this);
        return testResults;
    }
    
    
    /**
     * internal marshaller, marshall atts to teh DOM
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            DAPQueryResponse obj = (DAPQueryResponse)xmlObject;
            
            if(obj.getTimeStamp() != null) 
            {
                domElement.setAttributeNS(null, DataResponseBaseType.ATT_TIME_STAMP, OpenLibertyHelpers.stringForDateTime(obj.getTimeStamp()));
            } 
            
            if(obj.getItemRefId() != null) 
            {
                domElement.setAttributeNS(null, ResponseType.ATT_ITEM_ID_REF, obj.getItemRefId());
            }         
            
            // marshall the unknown attributes
            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }
        
        }

        
        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            // no element content
        }

        
        
    }
    
    
    /**
     * Internal class that handles unmarshalling DOM elements and atts to xmltooling objects
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {       
        
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {            
            DAPQueryResponse obj = (DAPQueryResponse) parentXMLObject;
                        
            // ResponseType
            if(childXMLObject instanceof Status)
            {
                   obj.setStatus((Status)childXMLObject);                   
            }
            else if(childXMLObject instanceof DAPData)
            {
                   obj.getDAPDatas().add((DAPData)childXMLObject);                   
            }
            else if(childXMLObject instanceof TestResult)
            {
                   obj.getTestResults().add((TestResult)childXMLObject);                   
            }
            // ResponseType
            else if(childXMLObject instanceof Extension)
            {
                   obj.getExtensions().add((Extension)childXMLObject);                   
            }
        }

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            
            DAPQueryResponse obj = (DAPQueryResponse) xmlObject;
            
            if (attribute.getLocalName().equals(DataResponseBaseType.ATT_TIME_STAMP)) 
            {
                obj.setTimeStamp(OpenLibertyHelpers.dateTimeForString(attribute.getValue()));
            } 
            else if (attribute.getLocalName().equals(ResponseType.ATT_ITEM_ID_REF)) 
            {
                obj.setItemRefId(attribute.getValue());
            } 
            // xs:anyAttribute from ResponseType
            else 
            {
                QName attribQName = QNameSupport.getNodeQName(attribute);
                if (attribute.isId()) 
                {
                    obj.getUnknownAttributes().registerID(attribQName);
                }
                obj.getUnknownAttributes().put(attribQName, attribute.getValue());
            }   
            
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            // no content            
        }
        
    }

    
    /**
     * Internal Class that builds a DAPQueryResponse object. 
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DAPQueryResponse> 
    {
        
        @Override
		public DAPQueryResponse buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new DAPQueryResponse(namespaceURI, localName, namespacePrefix);
        }
        
    }

    
    
    
}
