package org.openliberty.xmltooling.idsis.dap;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.dst2_1.ResultQueryBaseType;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;


/**
 *  This class is almost identical to the reference DST2.1 implementation
 *  of ResultQueryType except that it stores a reference to DAPSelect, which
 *  is a subclass of the DST2.1 reference Select.
 *  <p>
 *  The DST2.1 reference implementation classes ResultQueryTypeMarshaller and 
 *  ResultQueryTypeUnmarshaller are used by xmltooling to marshall and unmarshall 
 *  ResultQuery
 *  </p>
 *  
 <xs:element name="ResultQuery" type="dap:ResultQueryType"/>
  <xs:complexType name="ResultQueryType">
    <xs:complexContent>
      <xs:extension base="dst:ResultQueryBaseType">
        <xs:sequence>
          <xs:element ref="dap:Select"  minOccurs="0" maxOccurs="1"/>
          <xs:element name="Sort"   minOccurs="0" maxOccurs="1" type="dap:SortType"/>
        </xs:sequence>
      </xs:extension>
    </xs:complexContent>
  </xs:complexType>
  
 * @author asa
 *
 */
public class DAPResultQuery extends ResultQueryBaseType
{
    
    // public static String LOCAL_NAME = "ResultQuery";
    
    // Elements
    public DAPSelect select;     // dap:Select
    public DAPSort sort;         // dap:SortType, xs:string
    
    protected DAPResultQuery(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }    
    
    /**
     * The Select object in the superclass is actually a DAPSelect
     * 
     */
    public DAPSelect getDAPSelect()
    {
        return select;
    }
    
    public void setDAPSelect(DAPSelect select)
    {
        this.select = prepareForAssignment(this.select, select);
    }
    
    public DAPSort getDAPSort()
    {
        return sort;
    }
    
    public void setDAPSort(DAPSort sort)
    {
        this.sort = prepareForAssignment(this.sort, sort);
    }
    
    
    @Override
    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();        

        // Add super kids 
        children.addAll(super.getOrderedChildren());
        
        if(null!=select) children.add(select);
        if(null!=sort) children.add(sort);

        return Collections.unmodifiableList(children);
    }
    
    
    public static class Unmarshaller extends ResultQueryBaseType.Unmarshaller
    {
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            DAPResultQuery obj = (DAPResultQuery)parentXMLObject;
            if(childXMLObject instanceof DAPSort)
            {
                obj.setDAPSort((DAPSort) childXMLObject);                
            }
            else if(childXMLObject instanceof DAPSelect)
            {
                obj.setDAPSelect((DAPSelect) childXMLObject);                
            }
            else
            {
                super.processChildElement(parentXMLObject, childXMLObject);
            }
        }
    }
    
    public static class Marshaller extends ResultQueryBaseType.Marshaller
    {        
    }
    
    /**
     * Internal class for the builder to simplify the class structure
     * 
     * @author asa
     *
     */
    public static class DAPResultQueryBuilder extends AbstractXMLObjectBuilder<DAPResultQuery> 
    {               
        @Override
		public DAPResultQuery buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new DAPResultQuery(namespaceURI, localName, namespacePrefix);
        } 
    }

    
}
