package org.openliberty.xmltooling.idsis.dap;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.subs.Subscription;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

/**
 * 
 *
 * <pre>
 * &lt;xs:element name="Subscription" type="dap:SubscriptionType"/&gt;
 * &lt;xs:complexType name="SubscriptionType"&gt;
 *   &lt;xs:complexContent&gt;
 *     &lt;xs:extension base="subs:SubscriptionType"&gt;
 *       &lt;xs:sequence&gt;
 *         &lt;xs:element ref="dap:ResultQuery" minOccurs="0" maxOccurs="unbounded"/&gt;
 *         &lt;xs:element name="Aggregation"    minOccurs="0" maxOccurs="1" type="dap:AggregationType"/&gt;
 *         &lt;xs:element name="Trigger"    minOccurs="0" maxOccurs="1" type="dap:TriggerType"/&gt;
 *       &lt;/xs:sequence&gt;
 *     &lt;/xs:extension&gt;
 *   &lt;/xs:complexContent&gt;
 * &lt;/xs:complexType&gt;
 * </pre>
 */
public class DAPSubscription extends Subscription
{
    
    // Elements
    private XMLObjectChildrenList<DAPResultQuery> resultQueries;
    private XSString aggregation;
    private XSString trigger;
    
    // Element Names
    public static String ELE_STR_AGGREGATION = "Aggregation";
    public static String ELE_STR_TRIGGER = "Trigger";
    
    protected DAPSubscription()
    {
        super(Konstantz.DAP_NS, LOCAL_NAME, Konstantz.DAP_PREFIX);
    }
    
    protected DAPSubscription(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public XSString aggregation()
    {
        return aggregation;
    }

    public void setAggregation(XSString aggregation)
    {
        this.aggregation = prepareForAssignment(this.aggregation, aggregation);
    }
    
    public XSString trigger()
    {
        return trigger;
    }

    public void setTrigger(XSString trigger)
    {
        this.trigger = prepareForAssignment(this.trigger, trigger);
    }
    
    public XMLObjectChildrenList<DAPResultQuery> getResultQueries()
    {
        if(null==resultQueries) resultQueries = new XMLObjectChildrenList<DAPResultQuery>(this);
        return resultQueries;
    }
    
    /**
     * Internal class that handles unmarshalling specific to 
     * DAPSubscription
     * 
     * @author asa
     *
     */
    public static class DAPSubscriptionUnmarshaller extends Subscription.Unmarshaller
    {       

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {            
            DAPSubscription obj = (DAPSubscription) parentXMLObject;

            if(childXMLObject instanceof XSString)
            {
                
                String localName = childXMLObject.getElementQName().getLocalPart();
                
                if(localName.equals(DAPSubscription.ELE_STR_AGGREGATION))
                {
                    obj.setAggregation((XSString)childXMLObject);
                }
                else if(localName.equals(DAPSubscription.ELE_STR_TRIGGER))
                {
                    obj.setTrigger((XSString)childXMLObject);                    
                }
                else 
                {
                    super.processChildElement(parentXMLObject, childXMLObject);
                }
                                
            }
            else if(childXMLObject instanceof DAPResultQuery)
            {
                obj.getResultQueries().add((DAPResultQuery)childXMLObject);                   
            }
            else
            {
                super.processChildElement(parentXMLObject, childXMLObject);
            } 
        }

    }
    
    
    
    
    /**
     * Internal class for the builder to simplify the class structure
     * 
     * @author asa
     *
     */
    public static class DAPSubscriptionBuilder extends AbstractXMLObjectBuilder<DAPSubscription> 
    {
        
        public DAPSubscription buildObject()
        {
            return new DAPSubscription(Konstantz.DAP_NS, LOCAL_NAME, Konstantz.DAP_PREFIX);
        }
               
        @Override
		public DAPSubscription buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new DAPSubscription(namespaceURI, localName, namespacePrefix);
        }
        
    }
    
    
}
