package org.openliberty.xmltooling.idsis.dap;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.ref.TestItem;
import org.openliberty.xmltooling.dst2_1.ref.TestOp;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;

/**
 * DAPTestItem uses all of the attributes of dst2_1.ref.TestItem but has a TestOp
 * that is a dap:SelectType.
 * <p>
 * unmarshaller: DAPTestItem$DAPTestItemUnmarshaller<br />
 * marshaller:  dst2_1.ref.TestItemMarshaller<br />
 * builder: DAPTestItem$DAPTestItemBuilder<br />
 * </p>
 * <p>
 * @see DAPSelect : DAPTestOp is a dap:SelectType which is modeled in DAPSelect
 * </p>
 * @author asa
 *
 */
public class DAPTestItem extends TestItem
{
    
    // Element    
    private DAPSelect dapTestOp;
    
    // Element Name
    public static String ELE_STR_TEST_OP = "TestOp";
    
    

    protected DAPTestItem(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public DAPSelect getDAPTestOp()
    {
        return dapTestOp;
    }
    
    public void setDAPTestOp(DAPSelect dapTestOp)
    {
        this.dapTestOp = dapTestOp;
    }
    
    @Override
	public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        children.add(dapTestOp); 
        return Collections.unmodifiableList(children);
    }
    
    
    
    
    
    /**
     * Internal class that handles unmarshalling specific to 
     * DAPTestItem
     * 
     * @author asa
     *
     */
    public static class DAPTestItemUnmarshaller extends org.openliberty.xmltooling.dst2_1.ref.TestItemUnmarshaller
    {               
        // processAttribute(XMLObject xmlObject, Attr attribute) handled in  TestItemUnmarshaller                
        /**
         * Only one child element of TestItem
         * 
         */
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {            
            DAPTestItem obj = (DAPTestItem) parentXMLObject;
            
            if(childXMLObject instanceof DAPSelect)
            {
                String localName = childXMLObject.getElementQName().getLocalPart();
                
                if(localName.equals(DAPTestItem.ELE_STR_TEST_OP))
                {
                    obj.setDAPTestOp((DAPSelect)childXMLObject);
                }
            }
        }
    }
        
    
    
    
    
    
    /**
     * This Builder is used to create a dap:TestOp which is a child 
     * element of DAPTestItem.  Although the DST2.1 reference implementation
     * of dstref:TestOp is that of a simple xs:string element, the dap:TestOp
     * is actually a DAPSelect. Only a builder is required, as the 
     * Marshaller, object class, and Unmarshaller is for DAPSelect.
     * 
     * @author asa
     *
     */
    public static class TestOpBuilder extends AbstractXMLObjectBuilder<DAPSelect> 
    {
        public DAPSelect buildObject()
        {
            return new DAPSelect(Konstantz.DAP_NS, TestOp.LOCAL_NAME, Konstantz.DAP_PREFIX);
        }
               
        @Override
		public DAPSelect buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new DAPSelect(namespaceURI, localName, namespacePrefix);
        }
    }
    
    
    
    
    /**
     * This is the builder for DAPTestItem. 
     * 
     * @author asa
     *
     */
    public static class DAPTestItemBuilder extends AbstractXMLObjectBuilder<DAPTestItem> 
    {
        public DAPTestItem buildObject()
        {
            return new DAPTestItem(Konstantz.DAP_NS, LOCAL_NAME, Konstantz.DAP_PREFIX);
        }
               
        @Override
		public DAPTestItem buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new DAPTestItem(namespaceURI, localName, namespacePrefix);
        }
    }
    
    
    
}
