package org.openliberty.xmltooling.idsis.dap;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.schema.impl.XSStringImpl;
import org.opensaml.core.xml.schema.impl.XSStringMarshaller;
import org.opensaml.core.xml.schema.impl.XSStringUnmarshaller;

/**
 *  If &lt;dn&gt; is omitted, or incomplete, the ID-SIS-DAP server MUST determine the correct distinguished name 
 *  from the identity information conveyed by the ID-WSF layer. 
 *  <p>
 *  If &lt;dn&gt; is provided, the ID-SIS-DAP server MAY further determine the actual distinguished name from the 
 *  identity information conveyed by the ID-WSF layer. In this case, the &lt;dn&gt; could act as the base suffix, 
 *  while the identity information would provide the naming attribute.
 *  <p>
 *  Section 4.5.1 "Search Request" of [RFC2251] describes how the DN is mapped to the baseObject<br />
 *  http://www.ietf.org/rfc/rfc2251.txt
 *  
 * @author asa
 *
 */
public class DN extends XSStringImpl
{
    
    public static final String LOCAL_NAME = "dn";
    
    protected DN()
    {
        super(Konstantz.DAP_NS, LOCAL_NAME, Konstantz.DAP_PREFIX);
    }
    
    protected DN(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    
    public static class Marshaller extends XSStringMarshaller
    {        
    }
    
    public static class Unmarshaller extends XSStringUnmarshaller
    {        
    }

    public static class Builder extends AbstractXMLObjectBuilder<DN>
    {
        @Override
        public DN buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new DN(namespaceURI, localName, namespacePrefix);
        }        
    }
    
}
