package org.openliberty.xmltooling.idsis.dap;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.dst2_1.DataResponseBaseType;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.openliberty.xmltooling.utility_2_0.ResponseType;
import org.openliberty.xmltooling.utility_2_0.Status;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;


/**
 * This is the base type class for dap:CreateResponse and dap:ModifyResponse
 * 
 * <pre>
 *  &lt;xs:complexType name="DataResponseType"&gt;
 *     &lt;xs:complexContent&gt;
 *       &lt;xs:extension base="dst:DataResponseBaseType"&gt;
 *         &lt;xs:sequence&gt;
 *           &lt;xs:element ref="dap:ItemData"  minOccurs="0" maxOccurs="unbounded"/&gt;
 *         &lt;/xs:sequence&gt;
 *       &lt;/xs:extension&gt;
 *     &lt;/xs:complexContent&gt;
 *   &lt;/xs:complexType&gt;
 *   </pre>
 *   
 * @author asa
 *
 */
public abstract class DataResponseType extends DataResponseBaseType
{

    private XMLObjectChildrenList<DAPItemData> itemDataList;
    
    protected DataResponseType(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public XMLObjectChildrenList<DAPItemData> getItemDataList()
    {
        if(null==itemDataList) itemDataList = new XMLObjectChildrenList<DAPItemData>(this);
        return itemDataList;
    }
    
    @Override
    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
                
        // Add super kids
        children.addAll(super.getOrderedChildren());
        
        // Add the local kids
        if(null!=itemDataList) children.addAll(itemDataList);
        
        return Collections.unmodifiableList(children);
    }
    
    
    /**
     * Used by xmltooling to unmarshall DOM elements and Attributes into 
     * the xmltooling java objects
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {
        
        /**
         * Places attribute values within java objects
         */
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            DataResponseType obj = (DataResponseType)xmlObject; 
            
            if(attribute.getLocalName().equals(DataResponseBaseType.ATT_TIME_STAMP)) 
            {
                obj.setTimeStamp(OpenLibertyHelpers.dateTimeForString( attribute.getValue() ));
            } 
            else if(attribute.getLocalName().equals(ResponseType.ATT_ITEM_ID_REF))
            {
                obj.setItemRefId(attribute.getValue());
            }
            // xs:anyAttribute
            else 
            {
                QName attribQName = QNameSupport.getNodeQName(attribute);
                if (attribute.isId()) 
                {
                    obj.getUnknownAttributes().registerID(attribQName);
                }
                obj.getUnknownAttributes().put(attribQName, attribute.getValue());
            }   
        }

        /**
         * Connects the child to the parent
         */
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            DataResponseType obj = (DataResponseType)parentXMLObject; 
            
            if(childXMLObject instanceof DAPItemData)
            {
                obj.getItemDataList().add((DAPItemData)childXMLObject);
            }
            // ResponseType.status
            else if(childXMLObject instanceof Status)
            {
                obj.setStatus((Status) childXMLObject);                
            }
            // ResponseType.extensions
            else if(childXMLObject instanceof Extension)
            {
                obj.getExtensions().add((Extension)childXMLObject);
            }
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            // no element content
        }
        
    }
    
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {
        
        /**
         * Marshall attributes from all of the base classes
         * 
         */
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            
            DataResponseType obj = (DataResponseType)xmlObject;
            
            if(obj.getTimeStamp() != null) 
            {
                domElement.setAttributeNS(null, DataResponseBaseType.ATT_TIME_STAMP, OpenLibertyHelpers.stringForDateTime( obj.getTimeStamp() ));
            } 
            
            if(obj.getItemRefId() != null) 
            {
                domElement.setAttributeNS(null, ResponseType.ATT_ITEM_ID_REF, obj.getItemRefId());
            } 

            // marshall the unknown attributes
            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }
            
            
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {

        }
        
    }
    
    

}



