package org.openliberty.xmltooling.idsis.dap;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.LocalizedLeafAttributes;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.impl.XSStringImpl;
import org.opensaml.core.xml.schema.impl.XSStringMarshaller;
import org.opensaml.core.xml.schema.impl.XSStringUnmarshaller;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * The LDIF element contains an LDIF string
 * <p>
 * [rfc2849]<br/>
 * http://www.ietf.org/rfc/rfc2849.txt<br/>
 * <br/>
 * Simple spec description:<br/>
 * http://webhelp.ucs.ed.ac.uk/direct/ldifspec.htm
 * 
 * </p>
 * 
 * @author asa
 *
 */
public class LDIF extends XSStringImpl
{    
    public static String LOCAL_NAME = "LDIF";
    
    private LocalizedLeafAttributes localizedLeafAttributes;
    
    public LDIF()
    {
        super(Konstantz.DAP_NS, LOCAL_NAME, Konstantz.DAP_PREFIX);
        localizedLeafAttributes = new LocalizedLeafAttributes();
    }
    
    protected LDIF(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        localizedLeafAttributes = new LocalizedLeafAttributes();
    }

    public LocalizedLeafAttributes getLocalizedLeafAttributes()
    {
        return localizedLeafAttributes;
    }
    
    
    
    /**
     * Internal class that handles unmarshalling the object from the DOM
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends XSStringUnmarshaller
    {       
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            LDIF obj = (LDIF)xmlObject;
            obj.getLocalizedLeafAttributes().processAttribute(attribute, obj);       
        }
    }


    /**
     * Internal class that handles marshalling the object to the DOM
     * 
     * @author asa
     *
     */
    public static class Marshaller extends XSStringMarshaller
    {
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            LDIF obj = (LDIF)xmlObject;
            obj.getLocalizedLeafAttributes().marshallAttributes(domElement);
        }
    }
    
    
    /**
     * Internal class for the builder to simplify the class structure
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<LDIF> 
    {
        @Override
		public LDIF buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new LDIF(namespaceURI, localName, namespacePrefix);
        }
    }
    
    
}
