package org.openliberty.xmltooling.ims;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.utility_2_0.Status;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * <pre>
 *     &lt;xs:element name="IdentityMappingResponse" type="IdentityMappingResponseType"/&gt;
 *     &lt;xs:complexType name="IdentityMappingResponseType"&gt;
 *         &lt;xs:sequence&gt;
 *             &lt;xs:element ref="lu:Status"/&gt;
 *             &lt;xs:element ref="MappingOutput" minOccurs="0" maxOccurs="unbounded"/&gt;
 *         &lt;/xs:sequence&gt;
 *         &lt;xs:anyAttribute namespace="##other" processContents="lax"/&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * 
 * @author asa
 *
 */
public class IdentityMappingResponse extends AbstractXMLObject implements AttributeExtensibleXMLObject
{
    public static final String LOCAL_NAME = "IdentityMappingResponse";
    
    // Elements
    private XMLObjectChildrenList<MappingOutput> mappingOutputs;
    private Status status;
    
    // Attributes
    private AttributeMap otherAttributes;

    protected IdentityMappingResponse(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public AttributeMap getUnknownAttributes()
    {
        if(null==otherAttributes) otherAttributes = new AttributeMap(this);
        return otherAttributes;
    }

    public XMLObjectChildrenList<MappingOutput> getMappingOutputs()
    {
        if(null==mappingOutputs) mappingOutputs = new XMLObjectChildrenList<MappingOutput>(this);
        return mappingOutputs;
    }

    public Status getStatus()
    {
        return status;
    }

    public void setStatus(Status status)
    {
        this.status = prepareForAssignment(this.status, status);
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(status);
        if(null!=mappingOutputs) children.addAll(mappingOutputs);
        
        return Collections.unmodifiableList(children);
    }


    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<IdentityMappingResponse>
    {
        @Override
        public IdentityMappingResponse buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new IdentityMappingResponse(namespaceURI, localName, namespacePrefix);
        }
    }
    

    /**
     * Internal marshaller, placing attribute values into the DOM
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            IdentityMappingResponse obj = (IdentityMappingResponse)xmlObject;

            // marshall the unknown attributes (supported by RequestType)
            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }            
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no element content
        }

    }

    /**
     * Internal unmarshaller, placing DOM atts into the XMLObject
     * and connecting child elements
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            IdentityMappingResponse obj = (IdentityMappingResponse) xmlObject;

            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) 
            {
                obj.getUnknownAttributes().registerID(attribQName);
            }
            obj.getUnknownAttributes().put(attribQName, attribute.getValue());
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            // no element content
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {

            IdentityMappingResponse o = (IdentityMappingResponse) parentXMLObject;        

            if (childXMLObject instanceof MappingOutput) 
            {
                o.getMappingOutputs().add((MappingOutput) childXMLObject);
            }
            else if (childXMLObject instanceof Status) 
            {
                o.setStatus((Status) childXMLObject);
            }

        }
    }



}