package org.openliberty.xmltooling.ims;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.security.Token;
import org.openliberty.xmltooling.security.TokenPolicy;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * <pre>
 *   &lt;xs:element name="MappingInput" type="MappingInputType"/&gt;
 *   &lt;xs:complexType name="MappingInputType"&gt;
 *       &lt;xs:sequence&gt;
 *           &lt;xs:element ref="sec:TokenPolicy" minOccurs="0"/&gt;
 *           &lt;xs:element ref="sec:Token" minOccurs="0"/&gt;
 *       &lt;/xs:sequence&gt;
 *       &lt;xs:attribute name="reqID" type="lu:IDType" use="optional"/&gt;
 *   &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class MappingInput extends AbstractXMLObject
{

    public static final String LOCAL_NAME = "MappingInput";

    // Attributes
    private String reqID;

    // Attribute Names
    public static final String ATT_REQ_ID = "reqID";

    // Elements
    private TokenPolicy tokenPolicy;
    private Token token;

    protected MappingInput(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getReqID()
    {
        return reqID;
    }

    public void setReqID(String reqID)
    {
        this.reqID = prepareForAssignment(this.reqID, reqID);
    }

    public Token getToken()
    {
        return token;
    }

    public void setToken(Token token)
    {
        this.token = prepareForAssignment(this.token, token);
    }

    public TokenPolicy getTokenPolicy()
    {
        return tokenPolicy;
    }

    public void setTokenPolicy(TokenPolicy tokenPolicy)
    {
        this.tokenPolicy = prepareForAssignment(this.tokenPolicy, tokenPolicy);
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(tokenPolicy);
        children.add(token);

        return Collections.unmodifiableList(children);
    }

    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<MappingInput>
    {
        @Override
        public MappingInput buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new MappingInput(namespaceURI, localName, namespacePrefix);
        }   
    }
    

    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {
        
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            MappingInput o = (MappingInput)xmlObject;

            if(o.getReqID() != null) 
            {
                domElement.setAttributeNS(null, MappingInput.ATT_REQ_ID, o.getReqID());
            }
            
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            // no element content
        }
        
    }
    
    
    /**
     * Ststic Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {
        
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            MappingInput o = (MappingInput) xmlObject;
            
            if (attribute.getLocalName().equals(MappingInput.ATT_REQ_ID)) 
            {
                o.setReqID(attribute.getValue());
            }     
        }

               
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {   
            MappingInput o = (MappingInput) parentXMLObject;        
            
            if (childXMLObject instanceof TokenPolicy) 
            {
                o.setTokenPolicy((TokenPolicy) childXMLObject);
            }
            else if(childXMLObject instanceof Token)
            {
                o.setToken((Token) childXMLObject);
            }                    
        }
        
        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            // no element content
        }

    }
    

}
