package org.openliberty.xmltooling.ims;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.security.Token;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * <pre>
 *   &lt;xs:element name="MappingOutput" type="MappingOutputType"/&gt;
 *   &lt;xs:complexType name="MappingOutputType"&gt;
 *       &lt;xs:sequence&gt;
 *           &lt;xs:element ref="sec:Token"/&gt;
 *       &lt;/xs:sequence&gt;
 *       &lt;xs:attribute name="reqRef" type="lu:IDReferenceType" use="optional"/&gt;
 *   &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class MappingOutput extends AbstractXMLObject
{

    public static final String LOCAL_NAME = "MappingOutput";

    // Attributes    
    private String reqRef;   // lu:IDReferenceType xs:string

    // Attribute Names
    public static final String ATT_REQ_REF = "reqRef";

    // Elements
    private Token token;

    protected MappingOutput(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    /**
     * This references the reqID of a MappingInput
     * 
     * @return
     */
    public String getReqRef()
    {
        return reqRef;
    }

    public void setReqRef(String reqRef)
    {
        this.reqRef = prepareForAssignment(this.reqRef, reqRef);
    }

    public Token getToken()
    {
        return token;
    }

    public void setToken(Token token)
    {
        this.token = prepareForAssignment(this.token, token);
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(token);

        return Collections.unmodifiableList(children);
    }

    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<MappingOutput>
    {
        @Override
        public MappingOutput buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new MappingOutput(namespaceURI, localName, namespacePrefix);
        }   
    }
    

    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {
        
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            MappingOutput o = (MappingOutput)xmlObject;

            if(o.getReqRef() != null) 
            {
                domElement.setAttributeNS(null, MappingOutput.ATT_REQ_REF, o.getReqRef());
            }
            
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            // no element content
        }
        
    }
    
    
    /**
     * Ststic Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {
        
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            MappingOutput o = (MappingOutput) xmlObject;
            
            if (attribute.getLocalName().equals(MappingOutput.ATT_REQ_REF)) 
            {
                o.setReqRef(attribute.getValue());
            }     
        }

               
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {   
            MappingOutput o = (MappingOutput) parentXMLObject;        
            
            if(childXMLObject instanceof Token)
            {
                o.setToken((Token) childXMLObject);
            }                    
        }
        
        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            // no element content
        }

    }
    

}
