package org.openliberty.xmltooling.pp;

import org.apache.log4j.Logger;
import org.openliberty.xmltooling.pp.dst2_1.ct.AddrType;
import org.openliberty.xmltooling.pp.dst2_1.ct.LComment;
import org.openliberty.xmltooling.pp.dst2_1.ct.LNick;
import org.openliberty.xmltooling.pp.dst2_1.ct.Nick;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class AddressCardUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    private static Logger log = Logger.getLogger(AddressCardUnmarshaller.class);
    
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        AddressCard ppObject = (AddressCard) xmlObject;
        ppObject.attributes().processAttribute(attribute, ppObject);
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        AddressCard ppObject = (AddressCard) parentXMLObject;        
        
        if(childXMLObject instanceof AddrType) ppObject.getAddrTypes().add((AddrType) childXMLObject);
        else if(childXMLObject instanceof Address) ppObject.setAddress((Address) childXMLObject);
        else if(childXMLObject instanceof Nick) ppObject.setNick((Nick) childXMLObject);
        else if(childXMLObject instanceof LNick) ppObject.getLNicks().add((LNick) childXMLObject);
        else if(childXMLObject instanceof LComment) ppObject.setLComment((LComment) childXMLObject);
        else if(childXMLObject instanceof Extension) ppObject.setExtension((Extension) childXMLObject);
        else
        {
            log.error("This element does not allow for unknown children.  Please use the Extensions element to extend the object data definition.");
            //ppObject.getUnknownXMLObjects().add(childXMLObject);
        }
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        // NO ELEMENT CONTENT
    }

    
}
