package org.openliberty.xmltooling.pp;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.dst2_1.CommonAttributes;
import org.openliberty.xmltooling.pp.dst2_1.ct.IDType;
import org.openliberty.xmltooling.pp.dst2_1.ct.IDValue;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

/**
 * Other identification number(s) 

 * @author asa
 *
 */
public class AltID extends AbstractSignableXMLObject 
{
    public static String LOCAL_NAME = "AltID";
    
    // Attributes
    private CommonAttributes attributes;
    
    // Elements
    private IDValue iDValue;    // REQUIRED
    private IDType iDType;
    private Extension extension;
    
    protected AltID(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        attributes = new CommonAttributes();
    }
    
    public CommonAttributes attributes()
    {
        return attributes;
    }
    
    public void setIDValue(IDValue iDValue) 
    {
        this.iDValue = prepareForAssignment(this.iDValue, iDValue);
    }

    public IDValue getIDValue() 
    { 
        return iDValue; 
    }    
    
    public void setIDType(IDType iDType) 
    {
        this.iDType = prepareForAssignment(this.iDType, iDType);
    }

    public IDType getIDType() 
    { 
        return iDType; 
    }    
    
    public void setExtension(Extension extension) 
    {
        this.extension = prepareForAssignment(this.extension, extension);
    }

    public Extension getExtension() 
    { 
        return extension; 
    }    
    
    
    public List<XMLObject> getOrderedChildren() 
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
                
        children.add(iDValue);        
        children.add(iDType);       
        children.add(extension);  

        return Collections.unmodifiableList(children);
    }   
    
}
