package org.openliberty.xmltooling.pp;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.dst2_1.CommonAttributes;
import org.openliberty.xmltooling.pp.dst2_1.ct.FN;
import org.openliberty.xmltooling.pp.dst2_1.ct.LFN;
import org.openliberty.xmltooling.pp.dst2_1.ct.LMN;
import org.openliberty.xmltooling.pp.dst2_1.ct.LPersonalTitle;
import org.openliberty.xmltooling.pp.dst2_1.ct.LSN;
import org.openliberty.xmltooling.pp.dst2_1.ct.MN;
import org.openliberty.xmltooling.pp.dst2_1.ct.PersonalTitle;
import org.openliberty.xmltooling.pp.dst2_1.ct.SN;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

/**
 * Name analyzed (decomposed) into its components
 * 
 * @author asa
 *
 */
public class AnalyzedName extends AbstractSignableXMLObject
{
	public static String LOCAL_NAME = "AnalyzedName";
		
	public static String ATT_NAME_SCHEME = "nameScheme";

	// Attributes
	private String nameScheme;				// xs:anyURI
	private CommonAttributes attributes;

	// Elements
    private PersonalTitle personalTitle;
	private XMLObjectChildrenList<LPersonalTitle> lPersonalTitles;	
    private FN fN;
	private XMLObjectChildrenList<LFN> lFNs;	
	private SN sN;
	private XMLObjectChildrenList<LSN> lSNs;	
	private MN mN;
	private XMLObjectChildrenList<LMN> lMNs;	
	private Extension extension;
    
	protected AnalyzedName(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);		
		attributes = new CommonAttributes();
	}

    // Attributes
	public CommonAttributes attributes()
	{
		return attributes;
	}
	
	public String getNameScheme()
	{
		return nameScheme;
	}
	
	public void setNameScheme(String nameScheme)
	{
		this.nameScheme = nameScheme;
	}
	
	// Elements
    public void setPersonalTitle(PersonalTitle personalTitle) 
    {
        this.personalTitle = prepareForAssignment(this.personalTitle, personalTitle);
    }

    public PersonalTitle getPersonalTitle() 
    { 
        return personalTitle; 
    }   
    
    public XMLObjectChildrenList<LPersonalTitle> getLPersonalTitles()
    {
        if(null==lPersonalTitles) lPersonalTitles = new XMLObjectChildrenList<LPersonalTitle>(this);
        return lPersonalTitles;
    }
    
    public void setFN(FN fN) 
    {
        this.fN = prepareForAssignment(this.fN, fN);
    }

    public FN getFN() 
    { 
        return fN; 
    }   
    
    public XMLObjectChildrenList<LFN> getLFNs()
    {
        if(null==lFNs) lFNs = new XMLObjectChildrenList<LFN>(this);
        return lFNs;
    }

    public void setSN(SN sN) 
    {
        this.sN = prepareForAssignment(this.sN, sN);
    }

    public SN getSN() 
    { 
        return sN; 
    }   
    
    public XMLObjectChildrenList<LSN> getLSNs()
    {
        if(null==lSNs) lSNs = new XMLObjectChildrenList<LSN>(this);
        return lSNs;
    }
    
    public void setMN(MN mN) 
    {
        this.mN = prepareForAssignment(this.mN, mN);
    }

    public MN getMN() 
    { 
        return mN; 
    }   
    
    public XMLObjectChildrenList<LMN> getLMNs()
    {
        if(null==lMNs) lMNs = new XMLObjectChildrenList<LMN>(this);
        return lMNs;
    }
    
	public void setExtension(Extension extension) 
	{
		this.extension = prepareForAssignment(this.extension, extension);
	}

	public Extension getExtension() 
	{ 
		return extension; 
	}    

    
    public List<XMLObject> getOrderedChildren() 
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
                
        children.add(personalTitle);        
        if(null!=lPersonalTitles) children.addAll(lPersonalTitles); 
        children.add(fN);       
        if(null!=lFNs) children.addAll(lFNs);   
        children.add(sN);       
        if(null!=lSNs) children.addAll(lSNs);   
        children.add(mN);       
        if(null!=lMNs) children.addAll(lMNs);   
        children.add(extension);  

        return Collections.unmodifiableList(children);
    }   
	
	
}
