package org.openliberty.xmltooling.pp;

import org.apache.log4j.Logger;
import org.openliberty.xmltooling.pp.dst2_1.ct.FN;
import org.openliberty.xmltooling.pp.dst2_1.ct.LFN;
import org.openliberty.xmltooling.pp.dst2_1.ct.LMN;
import org.openliberty.xmltooling.pp.dst2_1.ct.LPersonalTitle;
import org.openliberty.xmltooling.pp.dst2_1.ct.LSN;
import org.openliberty.xmltooling.pp.dst2_1.ct.MN;
import org.openliberty.xmltooling.pp.dst2_1.ct.PersonalTitle;
import org.openliberty.xmltooling.pp.dst2_1.ct.SN;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class AnalyzedNameUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    private static Logger log = Logger.getLogger(AnalyzedNameUnmarshaller.class);
    
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        AnalyzedName ppObject = (AnalyzedName) xmlObject;
        if (!ppObject.attributes().processAttribute(attribute, ppObject) && attribute.getLocalName().equals(AnalyzedName.ATT_NAME_SCHEME)) 
        {
            ppObject.setNameScheme(attribute.getValue());
        }
    }
    
    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        AnalyzedName ppObject = (AnalyzedName) parentXMLObject;        
        if(childXMLObject instanceof PersonalTitle) ppObject.setPersonalTitle((PersonalTitle) childXMLObject);
        else if(childXMLObject instanceof LPersonalTitle) ppObject.getLPersonalTitles().add((LPersonalTitle) childXMLObject);
        else if(childXMLObject instanceof FN) ppObject.setFN((FN) childXMLObject);
        else if(childXMLObject instanceof LFN) ppObject.getLFNs().add((LFN) childXMLObject);
        else if(childXMLObject instanceof SN) ppObject.setSN((SN) childXMLObject);
        else if(childXMLObject instanceof LSN) ppObject.getLSNs().add((LSN) childXMLObject);
        else if(childXMLObject instanceof MN) ppObject.setMN((MN) childXMLObject);
        else if(childXMLObject instanceof LMN) ppObject.getLMNs().add((LMN) childXMLObject);
        else if(childXMLObject instanceof Extension) ppObject.setExtension((Extension) childXMLObject);
        else
        {
            log.error("This element does not allow for unknown children.  Please use the Extensions element to extend the object data definition.");
            //ppObject.getUnknownXMLObjects().add(childXMLObject);
        }
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        // NO ELEMENT CONTENT
    }

    
}
