package org.openliberty.xmltooling.pp;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.CommonAttributes;
import org.openliberty.xmltooling.pp.dst2_1.ct.AltCN;
import org.openliberty.xmltooling.pp.dst2_1.ct.CN;
import org.openliberty.xmltooling.pp.dst2_1.ct.LAltCN;
import org.openliberty.xmltooling.pp.dst2_1.ct.LCN;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

/**
 * The name the user prefers to be referred to with in everyday situations
 * 
 * @author asa
 *
 */
public class CommonName extends AbstractSignableXMLObject
{
    public static String LOCAL_NAME = "CommonName";
    public static String XPATH_SELECTOR = "/pp:PP/pp:CommonName";
    
    
    // Attributes
    private CommonAttributes attributes;

    // Child Elements
    private CN cN;
    private XMLObjectChildrenList<LCN> lCNs;
    private XMLObjectChildrenList<AltCN> altCNs;
    private XMLObjectChildrenList<LAltCN> lAltCNs;
    private AnalyzedName analyzedName;
    private Extension extension;


    public CommonName()
    {
        super(Konstantz.PP_NS, LOCAL_NAME, Konstantz.PP_PREFIX);
        attributes = new CommonAttributes();
    }

    protected CommonName(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        attributes = new CommonAttributes();
    }

    // Attributes
    public CommonAttributes attributes()
    {
        return attributes;
    }

    // Elements
    public void setCN(CN cN) 
    {
        this.cN = prepareForAssignment(this.cN, cN);
    }

    public CN getCN() 
    { 
        return cN; 
    }  

    public XMLObjectChildrenList<LCN> getLCNs()
    {
        if(null==lCNs) lCNs = new XMLObjectChildrenList<LCN>(this);
        return lCNs;
    }

    public XMLObjectChildrenList<AltCN> getAltCNs()
    {
        if(null==altCNs) altCNs = new XMLObjectChildrenList<AltCN>(this);
        return altCNs;
    }

    public XMLObjectChildrenList<LAltCN> getLAltCNs()
    {
        if(null==lAltCNs) lAltCNs = new XMLObjectChildrenList<LAltCN>(this);
        return lAltCNs;
    }

    public void setAnalyzedName(AnalyzedName analyzedName) 
    {
        this.analyzedName = prepareForAssignment(this.analyzedName, analyzedName);
    }

    public AnalyzedName getAnalyzedName() 
    { 
        return analyzedName; 
    }    

    public void setExtension(Extension extension) 
    {
        this.extension = prepareForAssignment(this.extension, extension);
    }

    public Extension getExtension() 
    { 
        return extension; 
    }    

    public List<XMLObject> getOrderedChildren() 
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(cN);
        if(null!=lCNs) children.addAll(lCNs);	
        if(null!=altCNs) children.addAll(altCNs);	
        if(null!=lAltCNs) children.addAll(lAltCNs);	
        children.add(analyzedName);
        children.add(extension);

        return Collections.unmodifiableList(children);
    }



    /*
    <xs:complexType name="CommonNameType">
    <xs:sequence>
        <xs:element ref="CN" minOccurs="0"/>
        <xs:element ref="LCN" minOccurs="0" maxOccurs="unbounded"/>
        <xs:element ref="AltCN" minOccurs="0" maxOccurs="unbounded"/>
        <xs:element ref="LAltCN" minOccurs="0" maxOccurs="unbounded"/>
        <xs:element ref="AnalyzedName" minOccurs="0"/>
        <xs:element ref="Extension" minOccurs="0"/>
    </xs:sequence>
    <xs:attributeGroup ref="commonAttributes"/>
     */
}
