package org.openliberty.xmltooling.pp;

import org.apache.log4j.Logger;
import org.openliberty.xmltooling.pp.dst2_1.ct.AltCN;
import org.openliberty.xmltooling.pp.dst2_1.ct.CN;
import org.openliberty.xmltooling.pp.dst2_1.ct.LAltCN;
import org.openliberty.xmltooling.pp.dst2_1.ct.LCN;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class CommonNameUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    private static Logger log = Logger.getLogger(CommonNameUnmarshaller.class);
    
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        CommonName ppObject = (CommonName) xmlObject;
        ppObject.attributes().processAttribute(attribute, ppObject);
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        CommonName ppObject = (CommonName) parentXMLObject;        
        
        if(childXMLObject instanceof CN) ppObject.setCN((CN) childXMLObject);
        else if(childXMLObject instanceof LCN) ppObject.getLCNs().add((LCN) childXMLObject);
        else if(childXMLObject instanceof AltCN) ppObject.getAltCNs().add((AltCN) childXMLObject);
        else if(childXMLObject instanceof LAltCN) ppObject.getLAltCNs().add((LAltCN) childXMLObject);
        else if(childXMLObject instanceof AnalyzedName) ppObject.setAnalyzedName((AnalyzedName) childXMLObject);
        else if(childXMLObject instanceof Extension) ppObject.setExtension((Extension) childXMLObject);
        else
        {
            log.error("This element does not allow for unknown children.  Please use the Extensions element to extend the object data definition.");
            //ppObject.getUnknownXMLObjects().add(childXMLObject);
        }
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        // NO ELEMENT CONTENT
    }

    
}
