package org.openliberty.xmltooling.pp;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.dst2_1.CommonAttributes;
import org.openliberty.xmltooling.pp.dst2_1.ct.Age;
import org.openliberty.xmltooling.pp.dst2_1.ct.Birthday;
import org.openliberty.xmltooling.pp.dst2_1.ct.DisplayLanguage;
import org.openliberty.xmltooling.pp.dst2_1.ct.Language;
import org.openliberty.xmltooling.pp.dst2_1.ct.TimeZone;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

/**
 * Base level demographics used by ID-PP
 * 
 * @author asa
 *
 */
public class Demographics extends AbstractSignableXMLObject
{
    public static String LOCAL_NAME = "Demographics";
        
    // Attributes
    private CommonAttributes attributes;

    // Elements
    private DisplayLanguage displayLanguage;
    private XMLObjectChildrenList<Language> languages;  
    private Birthday birthday;
    private Age age;
    private TimeZone timeZone;  
    private Extension extension;
    
    protected Demographics(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);     
        attributes = new CommonAttributes();
    }

    // Attributes
    public CommonAttributes attributes()
    {
        return attributes;
    }
    
    // Elements
    public void setDisplayLanguage(DisplayLanguage displayLanguage) 
    {
        this.displayLanguage = prepareForAssignment(this.displayLanguage, displayLanguage);
    }

    public DisplayLanguage getDisplayLanguage() 
    { 
        return displayLanguage; 
    }
    
    public XMLObjectChildrenList<Language> getLanguages()
    {
        if(null==languages) languages = new XMLObjectChildrenList<Language>(this);
        return languages;
    }

    public void setBirthday(Birthday birthday) 
    {
        this.birthday = prepareForAssignment(this.birthday, birthday);
    }

    public Birthday getBirthday() 
    { 
        return birthday; 
    }    
     
    public void setAge(Age age) 
    {
        this.age = prepareForAssignment(this.age, age);
    }

    public Age getAge() 
    { 
        return age; 
    }    
    
    public void setTimeZone(TimeZone timeZone) 
    {
        this.timeZone = prepareForAssignment(this.timeZone, timeZone);
    }

    public TimeZone getTimeZone() 
    { 
        return timeZone; 
    }    
    
    public void setExtension(Extension extension) 
    {
        this.extension = prepareForAssignment(this.extension, extension);
    }

    public Extension getExtension() 
    { 
        return extension; 
    }    
    
    public List<XMLObject> getOrderedChildren() 
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
                
        children.add(displayLanguage);        
        if(null!=languages) children.addAll(languages); 
        children.add(birthday);       
        children.add(age);       
        children.add(timeZone);       
        children.add(extension);  

        return Collections.unmodifiableList(children);
    }   
    
}