package org.openliberty.xmltooling.pp;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.dst2_1.CommonAttributes;
import org.openliberty.xmltooling.pp.dst2_1.ct.AltLO;
import org.openliberty.xmltooling.pp.dst2_1.ct.AltO;
import org.openliberty.xmltooling.pp.dst2_1.ct.JobTitle;
import org.openliberty.xmltooling.pp.dst2_1.ct.LJobTitle;
import org.openliberty.xmltooling.pp.dst2_1.ct.LO;
import org.openliberty.xmltooling.pp.dst2_1.ct.O;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

/**
 * Minimal Employer and employment details
 * 
 * @author asa
 *
 */
public class EmploymentIdentity extends AbstractSignableXMLObject
{
    public static String LOCAL_NAME = "EmploymentIdentity";

    // Attributes
    private CommonAttributes attributes;
    
    // Elements
    private JobTitle jobTitle;
    private XMLObjectChildrenList<LJobTitle> lJobTitles;  
    private O o;
    private LO lO;    
    private XMLObjectChildrenList<AltO> altOs;
    private XMLObjectChildrenList<AltLO> altLOs;
    private Extension extension;

    protected EmploymentIdentity(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);     
        attributes = new CommonAttributes();
    }

    // Attributes
    public CommonAttributes attributes()
    {
        return attributes;
    }

    // Elements
    public void setJobTitle(JobTitle jobTitle) 
    {
        this.jobTitle = prepareForAssignment(this.jobTitle, jobTitle);
    }

    public JobTitle getJobTitle() 
    { 
        return jobTitle; 
    }   

    public XMLObjectChildrenList<LJobTitle> getLJobTitles()
    {
        if(null==lJobTitles) lJobTitles = new XMLObjectChildrenList<LJobTitle>(this);
        return lJobTitles;
    }
    
    public void setO(O o) 
    {
        this.o = prepareForAssignment(this.o, o);
    }

    public O getO() 
    { 
        return o; 
    }   

    public void setLO(LO lO) 
    {
        this.lO = prepareForAssignment(this.lO, lO);
    }
    
    public LO getLO()
    {
        return lO;
    }    
    
    public XMLObjectChildrenList<AltO> getAltOs()
    {
        if(null==altOs) altOs = new XMLObjectChildrenList<AltO>(this);
        return altOs;
    }

    public XMLObjectChildrenList<AltLO> getAltLOs()
    {
        if(null==altLOs) altLOs = new XMLObjectChildrenList<AltLO>(this);
        return altLOs;
    }    
    
    public void setExtension(Extension extension) 
    {
        this.extension = prepareForAssignment(this.extension, extension);
    }

    public Extension getExtension() 
    { 
        return extension; 
    }    

    public List<XMLObject> getOrderedChildren() 
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(jobTitle);        
        if(null!=lJobTitles) children.addAll(lJobTitles); 
        children.add(o);       
        children.add(lO);
        if(null!=altOs) children.addAll(altOs);       
        if(null!=altLOs) children.addAll(altLOs);   
        children.add(extension);  

        return Collections.unmodifiableList(children);
    }   

}


/*
<xs:element name="EmploymentIdentity" type="EmploymentIdentityType"/>
<xs:complexType name="EmploymentIdentityType">
    <xs:sequence>
        <xs:element ref="JobTitle" minOccurs="0"/>
        <xs:element ref="LJobTitle" minOccurs="0" maxOccurs="unbounded"/>
        <xs:element ref="O" minOccurs="0"/>
        <xs:element ref="LO" minOccurs="0"/>
        <xs:element ref="AltO" minOccurs="0" maxOccurs="unbounded"/>
        <xs:element ref="AltLO" minOccurs="0" maxOccurs="unbounded"/>
        <xs:element ref="Extension" minOccurs="0"/>
    </xs:sequence>
    <xs:attributeGroup ref="commonAttributes"/>
</xs:complexType>
*/

