package org.openliberty.xmltooling.pp;

import org.apache.log4j.Logger;
import org.openliberty.xmltooling.pp.dst2_1.ct.AltLO;
import org.openliberty.xmltooling.pp.dst2_1.ct.AltO;
import org.openliberty.xmltooling.pp.dst2_1.ct.JobTitle;
import org.openliberty.xmltooling.pp.dst2_1.ct.LJobTitle;
import org.openliberty.xmltooling.pp.dst2_1.ct.LO;
import org.openliberty.xmltooling.pp.dst2_1.ct.O;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class EmploymentIdentityUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    private static Logger log = Logger.getLogger(EmploymentIdentityUnmarshaller.class);
    
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        EmploymentIdentity ppObject = (EmploymentIdentity) xmlObject;
        ppObject.attributes().processAttribute(attribute, ppObject);
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        EmploymentIdentity ppObject = (EmploymentIdentity) parentXMLObject;        
        
        if(childXMLObject instanceof JobTitle) ppObject.setJobTitle((JobTitle) childXMLObject);
        else if(childXMLObject instanceof LJobTitle) ppObject.getLJobTitles().add((LJobTitle) childXMLObject);
        else if(childXMLObject instanceof O) ppObject.setO((O) childXMLObject);
        else if(childXMLObject instanceof LO) ppObject.setLO((LO) childXMLObject);
        else if(childXMLObject instanceof AltO) ppObject.getAltOs().add((AltO) childXMLObject);
        else if(childXMLObject instanceof AltLO) ppObject.getAltLOs().add((AltLO) childXMLObject);
        else if(childXMLObject instanceof Extension) ppObject.setExtension((Extension) childXMLObject);
        else
        {
            log.error("This element does not allow for unknown children.  Please use the Extensions element to extend the object data definition.");
            //ppObject.getUnknownXMLObjects().add(childXMLObject);
        }
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        // NO ELEMENT CONTENT
    }

    
}
