package org.openliberty.xmltooling.pp;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.xmlsec.signature.impl.KeyInfoMarshaller;
import org.w3c.dom.Element;

public class EncryptKeyMarshaller extends KeyInfoMarshaller //AbstractXMLObjectMarshaller
{

    public EncryptKeyMarshaller() 
    {
        // A.H. 2008.12.17 - commented out when upgrading to SAML 2.2.2
        // super(XMLConstants.XMLSIG_NS, EncryptKey.LOCAL_NAME);
    }
        
    @Override
    protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException 
    {
        // Marshalls the "Id" attribute
        super.marshallAttributes(xmlObject, domElement);        

        // Marshall everything else
        EncryptKey ppObject = (EncryptKey)xmlObject;        
        ppObject.attributes().marshallAttributes(domElement);        
    }

}
