package org.openliberty.xmltooling.pp;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.xmlsec.signature.impl.KeyInfoUnmarshaller;
import org.w3c.dom.Attr;

/**
 * Unmarshaller for EncryptKey, relies on the KeyInfoTypeUnmarshaller defined
 * in the OpenSAML signature library
 * 
 * 
 * @author asa
 *
 */
public class EncryptKeyUnmarshaller extends KeyInfoUnmarshaller
{

    protected EncryptKeyUnmarshaller()
    {
        // A.H. 2008.12.17 - commented out when upgrading to SAML 2.2.2
        // super(XMLConstants.XMLSIG_NS, EncryptKey.LOCAL_NAME);
    }

    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        EncryptKey ppObject = (EncryptKey) xmlObject;
        if(!ppObject.attributes().processAttribute(attribute, ppObject))
        {
            super.processAttribute(xmlObject, attribute);
        }
    }


}
