package org.openliberty.xmltooling.pp;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.CommonAttributes;
import org.openliberty.xmltooling.dst2_1.DSTURI;
import org.openliberty.xmltooling.pp.dst2_1.ct.GreetMeSound;
import org.openliberty.xmltooling.pp.dst2_1.ct.GreetSound;
import org.openliberty.xmltooling.pp.dst2_1.ct.MugShot;
import org.openliberty.xmltooling.pp.dst2_1.ct.NamePronounced;
import org.openliberty.xmltooling.pp.dst2_1.ct.WebSite;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

/**
 * Principal's look and sound facade
 * 
 * @author asa
 *
 */
public class Facade extends AbstractSignableXMLObject
{

    public static String LOCAL_NAME = "Facade";

    public static String XPATH_SELECTOR = "/pp:PP/pp:Facade";
    
    // Attributes
    private CommonAttributes attributes;

    // Elements
    private MugShot mugShot;
    private WebSite webSite;
    private NamePronounced namePronounced;
    private GreetSound greetSound;    
    private GreetMeSound greetMeSound;    
    private Extension extension;
    
    public Facade()
    {
        super(Konstantz.PP_NS, LOCAL_NAME, Konstantz.PP_PREFIX);
        attributes = new CommonAttributes();
    }

    public Facade(boolean createAllChildren)
    {
        super(Konstantz.PP_NS, LOCAL_NAME, Konstantz.PP_PREFIX);
        if(createAllChildren)
        {
            this.setMugShot(new MugShot());
            this.setWebSite(new WebSite());
            this.setNamePronounced(new NamePronounced());
            this.setGreetSound(new GreetSound());
            this.setGreetMeSound(new GreetMeSound());
        }        
        attributes = new CommonAttributes();
    }
    
    public Facade(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);     
        attributes = new CommonAttributes();
    }

    // Attributes
    public CommonAttributes attributes()
    {
        return attributes;
    }
    
    // Elements
    public void setGreetMeSound(GreetMeSound greetMeSound) 
    {
        this.greetMeSound = prepareForAssignment(this.greetMeSound, greetMeSound);
    }

    public GreetMeSound getGreetMeSound() 
    { 
        return greetMeSound; 
    }
    
    public void setGreetSound(GreetSound greetSound) 
    {
        this.greetSound = prepareForAssignment(this.greetSound, greetSound);
    }

    public GreetSound getGreetSound() 
    { 
        return greetSound; 
    }    
    
    public void setNamePronounced(NamePronounced namePronounced) 
    {
        this.namePronounced = prepareForAssignment(this.namePronounced, namePronounced);
    }

    public NamePronounced getNamePronounced() 
    { 
        return namePronounced; 
    }
    
    public void setWebSite(WebSite webSite) 
    {
        this.webSite = prepareForAssignment(this.webSite, webSite);
    }

    public WebSite getWebSite() 
    { 
        return webSite; 
    }    

    public void setMugShot(MugShot mugShot) 
    {
        this.mugShot = prepareForAssignment(this.mugShot, mugShot);
    }

    public MugShot getMugShot() 
    { 
        return mugShot; 
    }    

    public void setExtension(Extension extension) 
    {
        this.extension = prepareForAssignment(this.extension, extension);
    }

    public Extension getExtension() 
    { 
        return extension; 
    }    

    public List<XMLObject> getOrderedChildren() 
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
                
        if(DSTURI.isValid(mugShot)) children.add(mugShot);
        if(DSTURI.isValid(webSite)) children.add(webSite);
        if(DSTURI.isValid(namePronounced)) children.add(namePronounced);
        if(DSTURI.isValid(greetSound)) children.add(greetSound);
        if(DSTURI.isValid(greetMeSound)) children.add(greetMeSound);

        children.add(extension);

        return Collections.unmodifiableList(children);
    }   
    
    
}
