package org.openliberty.xmltooling.pp;

import org.apache.log4j.Logger;
import org.openliberty.xmltooling.pp.dst2_1.ct.GreetMeSound;
import org.openliberty.xmltooling.pp.dst2_1.ct.GreetSound;
import org.openliberty.xmltooling.pp.dst2_1.ct.MugShot;
import org.openliberty.xmltooling.pp.dst2_1.ct.NamePronounced;
import org.openliberty.xmltooling.pp.dst2_1.ct.WebSite;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;


public class FacadeUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    private static Logger log = Logger.getLogger(FacadeUnmarshaller.class);
    
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        Facade ppObject = (Facade) xmlObject;
        ppObject.attributes().processAttribute(attribute, ppObject);
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        Facade ppObject = (Facade) parentXMLObject;        
        
        if(childXMLObject instanceof MugShot) ppObject.setMugShot((MugShot) childXMLObject);
        else if(childXMLObject instanceof WebSite) ppObject.setWebSite((WebSite) childXMLObject);
        else if(childXMLObject instanceof NamePronounced) ppObject.setNamePronounced((NamePronounced) childXMLObject);
        else if(childXMLObject instanceof GreetSound) ppObject.setGreetSound((GreetSound) childXMLObject);
        else if(childXMLObject instanceof GreetMeSound) ppObject.setGreetMeSound((GreetMeSound) childXMLObject);
        else if(childXMLObject instanceof Extension) ppObject.setExtension((Extension) childXMLObject);
        else
        {
            log.error("This element does not allow for unknown children.  Please use the Extensions element to extend the object data definition.");
            //ppObject.getUnknownXMLObjects().add(childXMLObject);
        }
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        // NO ELEMENT CONTENT
    }

    
}
