package org.openliberty.xmltooling.pp;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.dst2_1.CommonAttributes;
import org.openliberty.xmltooling.pp.dst2_1.ct.DOB;
import org.openliberty.xmltooling.pp.dst2_1.ct.Gender;
import org.openliberty.xmltooling.pp.dst2_1.ct.LLegalName;
import org.openliberty.xmltooling.pp.dst2_1.ct.LegalName;
import org.openliberty.xmltooling.pp.dst2_1.ct.MaritalStatus;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

public class LegalIdentity extends AbstractSignableXMLObject
{

    public static String LOCAL_NAME = "LegalIdentity";

    // Attributes
    private CommonAttributes attributes;

    // Elements
    private LegalName legalName;
    private XMLObjectChildrenList<LLegalName> lLegalNames;
    private AnalyzedName analyzedName;
    private VAT vAT;
    private XMLObjectChildrenList<AltID> altIDs;
    private DOB dOB;
    private Gender gender;
    private MaritalStatus maritalStatus;
    private Extension extension;
    
    protected LegalIdentity(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        attributes = new CommonAttributes();
    }

    // Attributes
    public CommonAttributes attributes()
    {
        return attributes;
    }
    
    // Elements
    public void setLegalName(LegalName legalName) 
    {
        this.legalName = prepareForAssignment(this.legalName, legalName);
    }

    public LegalName getLegalName() 
    { 
        return legalName; 
    }   
    
    public XMLObjectChildrenList<LLegalName> getLLegalNames()
    {
        if(null==lLegalNames) lLegalNames = new XMLObjectChildrenList<LLegalName>(this);
        return lLegalNames;
    }
        
    public void setAnalyzedName(AnalyzedName analyzedName) 
    {
        this.analyzedName = prepareForAssignment(this.analyzedName, analyzedName);
    }

    public AnalyzedName getAnalyzedName() 
    { 
        return analyzedName; 
    }   

    public void setVAT(VAT vAT) 
    {
        this.vAT = prepareForAssignment(this.vAT, vAT);
    }

    public VAT getVAT() 
    { 
        return vAT; 
    }  
    
    public XMLObjectChildrenList<AltID> getAltIDs()
    {
        if(null==altIDs) altIDs = new XMLObjectChildrenList<AltID>(this);
        return altIDs;
    }
    
    public void setDOB(DOB dOB) 
    {
        this.dOB = prepareForAssignment(this.dOB, dOB);
    }

    public DOB getDOB() 
    { 
        return dOB; 
    }    
    
    public void setGender(Gender gender) 
    {
        this.gender = prepareForAssignment(this.gender, gender);
    }

    public Gender getGender() 
    { 
        return gender; 
    }    
    
    
    public void setMaritalStatus(MaritalStatus maritalStatus) 
    {
        this.maritalStatus = prepareForAssignment(this.maritalStatus, maritalStatus);
    }

    public MaritalStatus getMaritalStatus() 
    { 
        return maritalStatus; 
    }    
    
    public void setExtension(Extension extension) 
    {
        this.extension = prepareForAssignment(this.extension, extension);
    }

    public Extension getExtension() 
    { 
        return extension; 
    }
    
    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        children.add(legalName);
        if(null!=lLegalNames) children.addAll(lLegalNames);   
        children.add(analyzedName);
        children.add(vAT);
        if(null!=altIDs) children.addAll(altIDs);   
        children.add(dOB);
        children.add(gender);
        children.add(maritalStatus);
        children.add(extension);

        return Collections.unmodifiableList(children);
    }

}

/*
<xs:complexType name="LegalIdentityType">
<xs:sequence>
    <xs:element ref="LegalName" minOccurs="0"/>
    <xs:element ref="LLegalName" minOccurs="0" maxOccurs="unbounded"/>
    <xs:element ref="AnalyzedName" minOccurs="0"/>
    <xs:element ref="VAT" minOccurs="0"/>
    <xs:element ref="AltID" minOccurs="0" maxOccurs="unbounded"/>
    <xs:element ref="DOB" minOccurs="0"/>
    <xs:element ref="Gender" minOccurs="0"/>
    <xs:element ref="MaritalStatus" minOccurs="0"/>
    <xs:element ref="Extension" minOccurs="0"/>
</xs:sequence>
<xs:attributeGroup ref="commonAttributes"/>
</xs:complexType>
*/