package org.openliberty.xmltooling.pp;

import org.apache.log4j.Logger;
import org.openliberty.xmltooling.pp.dst2_1.ct.DOB;
import org.openliberty.xmltooling.pp.dst2_1.ct.Gender;
import org.openliberty.xmltooling.pp.dst2_1.ct.LLegalName;
import org.openliberty.xmltooling.pp.dst2_1.ct.LegalName;
import org.openliberty.xmltooling.pp.dst2_1.ct.MaritalStatus;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;


public class LegalIdentityUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    private static Logger log = Logger.getLogger(LegalIdentityUnmarshaller.class);
    
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        LegalIdentity ppObject = (LegalIdentity) xmlObject;
        ppObject.attributes().processAttribute(attribute, ppObject);
    }
    
    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        LegalIdentity ppObject = (LegalIdentity) parentXMLObject;        
        
        if(childXMLObject instanceof LegalName) ppObject.setLegalName((LegalName) childXMLObject);
        else if(childXMLObject instanceof LLegalName) ppObject.getLLegalNames().add((LLegalName) childXMLObject);
        else if(childXMLObject instanceof AnalyzedName) ppObject.setAnalyzedName((AnalyzedName) childXMLObject);
        else if(childXMLObject instanceof VAT) ppObject.setVAT((VAT) childXMLObject);
        else if(childXMLObject instanceof AltID) ppObject.getAltIDs().add((AltID) childXMLObject);
        else if(childXMLObject instanceof DOB) ppObject.setDOB((DOB) childXMLObject);
        else if(childXMLObject instanceof Gender) ppObject.setGender((Gender) childXMLObject);
        else if(childXMLObject instanceof MaritalStatus) ppObject.setMaritalStatus((MaritalStatus) childXMLObject);
        else if(childXMLObject instanceof Extension) ppObject.setExtension((Extension) childXMLObject);
        else
        {
            log.error("This element does not allow for unknown children.  Please use the Extensions element to extend the object data definition.");
            //ppObject.getUnknownXMLObjects().add(childXMLObject);
        }
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        // NO ELEMENT CONTENT
    }

    
}
