package org.openliberty.xmltooling.pp;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

import org.joda.time.DateTime;
import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.CommonAttributes;
import org.openliberty.xmltooling.pp.dst2_1.ct.LComment;
import org.openliberty.xmltooling.pp.dst2_1.ct.LNick;
import org.openliberty.xmltooling.pp.dst2_1.ct.MsgAccount;
import org.openliberty.xmltooling.pp.dst2_1.ct.MsgMethod;
import org.openliberty.xmltooling.pp.dst2_1.ct.MsgProvider;
import org.openliberty.xmltooling.pp.dst2_1.ct.MsgSubaccount;
import org.openliberty.xmltooling.pp.dst2_1.ct.MsgType;
import org.openliberty.xmltooling.pp.dst2_1.ct.Nick;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

/**
 * Generic phone, email, or instant messaging contact information
 * 
 * @author asa
 *
 */
public class MsgContact extends AbstractSignableXMLObject
{

    public static String LOCAL_NAME = "MsgContact";

    public static String XPATH_SELECTOR = "/pp:PP/pp:MsgContact";
    
    // Attributes
    private CommonAttributes attributes;

    // Elements
    private Nick nick;
    private XMLObjectChildrenList<LNick> lNicks;  
    private LComment lComment;
    private XMLObjectChildrenList<MsgType> msgTypes;
    private XMLObjectChildrenList<MsgMethod> msgMethods;
    private XMLObjectChildrenList<MsgTechnology> msgTechnologies;
    private MsgProvider msgProvider;
    private MsgAccount msgAccount;
    private MsgSubaccount msgSubAccount;
    private Extension extension;

    public MsgContact(boolean createChildren)
    {
        super(Konstantz.PP_NS, LOCAL_NAME, Konstantz.PP_PREFIX);
        attributes = new CommonAttributes();        
        if(createChildren)
        {
            attributes.setId(UUID.randomUUID().toString(), this);    
            attributes.setModificationTime(new DateTime(), this);
            this.setNick(new Nick());
            this.setLComment(new LComment());
            this.setMsgProvider(new MsgProvider());
            this.setMsgAccount(new MsgAccount());
            this.setMsgSubaccount(new MsgSubaccount());      
        }
    }


    public MsgContact()
    {
        super(Konstantz.PP_NS, LOCAL_NAME, Konstantz.PP_PREFIX);
        attributes = new CommonAttributes();
    }

    public MsgContact(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);     
        attributes = new CommonAttributes();
    }

    // Attributes
    public CommonAttributes attributes()
    {
        return attributes;
    }

    // Elements
    public void setNick(Nick nick) 
    {
        this.nick = prepareForAssignment(this.nick, nick);
    }

    public Nick getNick() 
    { 
        return nick; 
    }   

    public XMLObjectChildrenList<LNick> getLNicks()
    {
        if(null==lNicks) lNicks = new XMLObjectChildrenList<LNick>(this);        
        return lNicks;
    }

    public void setLComment(LComment lComment) 
    {
        this.lComment = prepareForAssignment(this.lComment, lComment);
    }

    public LComment getLComment() 
    { 
        return lComment; 
    }   

    /**
     * Gets the first MsgMethod as the enum MsgMethod.Method
     * 
     * @return
     */
    public MsgMethod.Method getMethod()
    {
        if(null!=msgMethods && msgMethods.size()>0) return msgMethods.get(0).getMethod();
        else return null;

    }

    public void setMethod(MsgMethod.Method method)
    {
        if(null!=msgMethods && msgMethods.size()>0) msgMethods.get(0).setMethod(method);
        else
        {
            MsgMethod msgMethod = new MsgMethod(method);
            getMsgMethods().add(msgMethod);
        }
    }


    public XMLObjectChildrenList<MsgType> getMsgTypes()
    {
        if(null==msgTypes) msgTypes = new XMLObjectChildrenList<MsgType>(this);
        return msgTypes;
    }

    public XMLObjectChildrenList<MsgMethod> getMsgMethods()
    {
        if(null==msgMethods) msgMethods = new XMLObjectChildrenList<MsgMethod>(this);
        return msgMethods;
    }

    public XMLObjectChildrenList<MsgTechnology> getMsgTechnologies()
    {
        if(null==msgTechnologies) msgTechnologies = new XMLObjectChildrenList<MsgTechnology>(this);
        return msgTechnologies;
    }

    public void setMsgProvider(MsgProvider msgProvider) 
    {
        this.msgProvider = prepareForAssignment(this.msgProvider, msgProvider);
    }

    public MsgProvider getMsgProvider() 
    { 
        return msgProvider; 
    }   

    public void setMsgAccount(MsgAccount msgAccount) 
    {
        this.msgAccount = prepareForAssignment(this.msgAccount, msgAccount);
    }

    public MsgAccount getMsgAccount() 
    { 
        return msgAccount; 
    }    

    public void setMsgSubaccount(MsgSubaccount msgSubAccount) 
    {
        this.msgSubAccount = prepareForAssignment(this.msgSubAccount, msgSubAccount);
    }

    public MsgSubaccount getMsgSubaccount() 
    { 
        return msgSubAccount; 
    }    

    public void setExtension(Extension extension) 
    {
        this.extension = prepareForAssignment(this.extension, extension);
    }

    public Extension getExtension() 
    { 
        return extension; 
    }    

    public List<XMLObject> getOrderedChildren() 
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(nick);        
        if(null!=lNicks) children.addAll(lNicks); 
        children.add(lComment);       
        if(null!=msgTypes) children.addAll(msgTypes);   
        if(null!=msgMethods) children.addAll(msgMethods);   
        if(null!=msgTechnologies) children.addAll(msgTechnologies);   
        children.add(msgProvider);  
        children.add(msgAccount);  
        children.add(msgSubAccount);  
        children.add(extension);  

        return Collections.unmodifiableList(children);
    }   

}

/*
<xs:element name="MsgContact" type="MsgContactType"/>
<xs:complexType name="MsgContactType">
    <xs:sequence>
        <xs:element ref="Nick" minOccurs="0"/>
        <xs:element ref="LNick" minOccurs="0" maxOccurs="unbounded"/>
        <xs:element ref="LComment" minOccurs="0"/>
        <xs:element ref="MsgType" minOccurs="0" maxOccurs="unbounded"/>
        <xs:element ref="MsgMethod" minOccurs="0" maxOccurs="unbounded"/>
        <xs:element ref="MsgTechnology" minOccurs="0" maxOccurs="unbounded"/>
        <xs:element ref="MsgProvider" minOccurs="0"/>
        <xs:element ref="MsgAccount" minOccurs="0"/>
        <xs:element ref="MsgSubaccount" minOccurs="0"/>
        <xs:element ref="Extension" minOccurs="0"/>
    </xs:sequence>
    <xs:attributeGroup ref="commonAttributes"/>
</xs:complexType>
 */