package org.openliberty.xmltooling.pp;

import org.apache.log4j.Logger;
import org.openliberty.xmltooling.pp.dst2_1.ct.LComment;
import org.openliberty.xmltooling.pp.dst2_1.ct.LNick;
import org.openliberty.xmltooling.pp.dst2_1.ct.MsgAccount;
import org.openliberty.xmltooling.pp.dst2_1.ct.MsgMethod;
import org.openliberty.xmltooling.pp.dst2_1.ct.MsgProvider;
import org.openliberty.xmltooling.pp.dst2_1.ct.MsgSubaccount;
import org.openliberty.xmltooling.pp.dst2_1.ct.MsgType;
import org.openliberty.xmltooling.pp.dst2_1.ct.Nick;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;


public class MsgContactUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    private static Logger log = Logger.getLogger(MsgContactUnmarshaller.class);
    
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        MsgContact ppObject = (MsgContact) xmlObject;
        ppObject.attributes().processAttribute(attribute, ppObject);
    }
    
    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        MsgContact ppObject = (MsgContact) parentXMLObject;        
        
        if(childXMLObject instanceof Nick) ppObject.setNick((Nick) childXMLObject);
        else if(childXMLObject instanceof LNick) ppObject.getLNicks().add((LNick) childXMLObject);
        else if(childXMLObject instanceof LComment) ppObject.setLComment((LComment) childXMLObject);
        else if(childXMLObject instanceof MsgType) ppObject.getMsgTypes().add((MsgType) childXMLObject);
        else if(childXMLObject instanceof MsgMethod) ppObject.getMsgMethods().add((MsgMethod) childXMLObject);
        else if(childXMLObject instanceof MsgTechnology) ppObject.getMsgTechnologies().add((MsgTechnology) childXMLObject);
        else if(childXMLObject instanceof MsgProvider) ppObject.setMsgProvider((MsgProvider) childXMLObject);
        else if(childXMLObject instanceof MsgAccount) ppObject.setMsgAccount((MsgAccount) childXMLObject);
        else if(childXMLObject instanceof MsgSubaccount) ppObject.setMsgSubaccount((MsgSubaccount) childXMLObject);
        else if(childXMLObject instanceof Extension) ppObject.setExtension((Extension) childXMLObject);
        else
        {
            log.error("This element does not allow for unknown children.  Please use the Extensions element to extend the object data definition.");
            //ppObject.getUnknownXMLObjects().add(childXMLObject);
        }
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        // NO ELEMENT CONTENT
    }

    
}
