package org.openliberty.xmltooling.pp;

import org.apache.commons.lang.math.NumberUtils;
import org.openliberty.xmltooling.dst2_1.DSTURIUnmarshaller;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;


public class MsgTechnologyUnmarshaller extends DSTURIUnmarshaller
{
    
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        MsgTechnology msgTechnology = (MsgTechnology) xmlObject;
        
        if (attribute.getLocalName().equals(MsgTechnology.ATT_MSG_LIMIT)) 
        {            
            
            if(NumberUtils.isNumber(attribute.getValue()))
            {
                msgTechnology.setMsgLimit(NumberUtils.createInteger(attribute.getValue()));
            }
            else 
            {
                msgTechnology.setMsgLimit(null);
            }
        
        } 
        else
        {
            super.processAttribute(xmlObject, attribute);
        }
    }    
    
}
