package org.openliberty.xmltooling.pp;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.CommonAttributes;
import org.openliberty.xmltooling.pp.dst2_1.ct.EmergencyContact;
import org.openliberty.xmltooling.pp.dst2_1.ct.InformalName;
import org.openliberty.xmltooling.pp.dst2_1.ct.LEmergencyContact;
import org.openliberty.xmltooling.pp.dst2_1.ct.LInformalName;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;


/**
 * This class models the Personal Profile Container element.
 * 
 * @author asa
 *
 */
public class PP extends AbstractSignableXMLObject 
{

	public static String NAMESPACE_URI = Konstantz.PP_NS;
	public static String NAMESPACE_PREFIX = Konstantz.PP_PREFIX;	
	public static String LOCAL_NAME = "PP";
	
	public static String XPATH_SELECTOR = "/pp:PP";

	// Attributes
	private CommonAttributes attributes;

	// Child Elements
	private InformalName informalName;
	private XMLObjectChildrenList<LInformalName> lInformalNames;	
	private CommonName commonName;
	private LegalIdentity legalIdentity;
	private EmploymentIdentity employmentIdentity;
	private XMLObjectChildrenList<AddressCard> addressCards;	
	private XMLObjectChildrenList<MsgContact> msgContacts;	
	private Facade facade;
	private Demographics demographics;
	private SignKey signKey;
	private EncryptKey encryptKey;
	private EmergencyContact emergencyContact;
	private XMLObjectChildrenList<LEmergencyContact> lEmergencyContacts;	
	private Extension extension;  


	protected PP(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);		
		attributes = new CommonAttributes();
	}

	public CommonAttributes attributes()
	{
		return attributes;
	}
	
	public List<XMLObject> getOrderedChildren() 
	{
		List<XMLObject> children = new LinkedList<XMLObject>();
		
		children.add(informalName);
		if(null!=lInformalNames) children.addAll(lInformalNames);	
		children.add(commonName);
		children.add(legalIdentity);
		children.add(employmentIdentity);
		if(null!=addressCards) children.addAll(addressCards);	
		if(null!=msgContacts) children.addAll(msgContacts);	
		children.add(facade);
		children.add(demographics);
		children.add(signKey);
		children.add(encryptKey);
		children.add(emergencyContact);
		if(null!=lEmergencyContacts) children.addAll(lEmergencyContacts);	
		children.add(extension);  

		return Collections.unmodifiableList(children);
	}	


	public void setExtension(Extension extension) 
	{
		this.extension = prepareForAssignment(this.extension, extension);
	}

	public Extension getExtension() 
	{ 
		return extension; 
	}    

	public XMLObjectChildrenList<LEmergencyContact> getLEmergencyContacts()
	{
        if(null==lEmergencyContacts) lEmergencyContacts = new XMLObjectChildrenList<LEmergencyContact>(this);
		return this.lEmergencyContacts;
	}

	public void setEmergencyContact(EmergencyContact emergencyContact) 
	{
		this.emergencyContact = prepareForAssignment(this.emergencyContact, emergencyContact);
	}

	public EmergencyContact getEmergencyContact() 
	{ 
		return emergencyContact; 
	}

	public void setEncryptKey(EncryptKey encryptKey) 
	{
		this.encryptKey = prepareForAssignment(this.encryptKey, encryptKey);
	}

	public EncryptKey getEncryptKey() 
	{ 
		return encryptKey; 
	}

	public void setSignKey(SignKey signKey) 
	{
		this.signKey = prepareForAssignment(this.signKey, signKey);
	}

	public SignKey getSignKey() 
	{ 
		return signKey; 
	}

	public void setDemographics(Demographics demographics) 
	{
		this.demographics = prepareForAssignment(this.demographics, demographics);
	}

	public Demographics getDemographics() 
	{ 
		return demographics; 
	}

	public void setFacade(Facade facade) 
	{
		this.facade = prepareForAssignment(this.facade, facade);
	}

	public Facade getFacade() 
	{ 
		return facade; 
	}

	public XMLObjectChildrenList<MsgContact> getMsgContacts()
	{
        if(null==msgContacts) msgContacts = new XMLObjectChildrenList<MsgContact>(this);
		return this.msgContacts;
	}

	public XMLObjectChildrenList<AddressCard> getAddressCards()
	{
        if(null==addressCards) addressCards = new XMLObjectChildrenList<AddressCard>(this);
		return this.addressCards;
	}

	public void setEmploymentIdentity(EmploymentIdentity employmentIdentity) 
	{
		this.employmentIdentity = prepareForAssignment(this.employmentIdentity, employmentIdentity);
	}

	public EmploymentIdentity getEmploymentIdentity() 
	{ 
		return employmentIdentity; 
	}

	public void setLegalIdentity(LegalIdentity legalIdentity) 
	{
		this.legalIdentity = prepareForAssignment(this.legalIdentity, legalIdentity);
	}

	public LegalIdentity getLegalIdentity() 
	{ 
		return legalIdentity; 
	}

	public void setCommonName(CommonName commonName) 
	{
		this.commonName = prepareForAssignment(this.commonName, commonName);
	}

	public CommonName getCommonName() 
	{ 
		return commonName; 
	}

	public XMLObjectChildrenList<LInformalName> getLInformalNames()
	{
        if(null==lInformalNames) lInformalNames = new XMLObjectChildrenList<LInformalName>(this);
		return this.lInformalNames;
	}

	public void setInformalName(InformalName informalName) 
	{
		this.informalName = prepareForAssignment(this.informalName, informalName);
	}

	public InformalName getInformalName() 
	{ 
		return informalName; 
	}


}
