package org.openliberty.xmltooling.pp;

import org.apache.log4j.Logger;
import org.openliberty.xmltooling.pp.dst2_1.ct.EmergencyContact;
import org.openliberty.xmltooling.pp.dst2_1.ct.InformalName;
import org.openliberty.xmltooling.pp.dst2_1.ct.LEmergencyContact;
import org.openliberty.xmltooling.pp.dst2_1.ct.LInformalName;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class PPUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    private static Logger log = Logger.getLogger(PPUnmarshaller.class);
    
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        PP ppObject = (PP) xmlObject;
        ppObject.attributes().processAttribute(attribute, ppObject);
    }
    
    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        PP ppObject = (PP) parentXMLObject;        
        
        if (childXMLObject instanceof InformalName) ppObject.setInformalName((InformalName) childXMLObject);
        else if(childXMLObject instanceof LInformalName) ppObject.getLInformalNames().add((LInformalName) childXMLObject);
        else if(childXMLObject instanceof CommonName) ppObject.setCommonName((CommonName) childXMLObject);
        else if(childXMLObject instanceof LegalIdentity) ppObject.setLegalIdentity((LegalIdentity) childXMLObject);
        else if(childXMLObject instanceof EmploymentIdentity) ppObject.setEmploymentIdentity((EmploymentIdentity) childXMLObject);
        else if(childXMLObject instanceof AddressCard) ppObject.getAddressCards().add((AddressCard) childXMLObject);
        else if(childXMLObject instanceof MsgContact) ppObject.getMsgContacts().add((MsgContact) childXMLObject);
        else if(childXMLObject instanceof Facade) ppObject.setFacade((Facade) childXMLObject);
        else if(childXMLObject instanceof Demographics) ppObject.setDemographics((Demographics) childXMLObject);
        else if(childXMLObject instanceof SignKey) ppObject.setSignKey((SignKey) childXMLObject);
        else if(childXMLObject instanceof EncryptKey) ppObject.setEncryptKey((EncryptKey) childXMLObject);
        else if(childXMLObject instanceof EmergencyContact) ppObject.setEmergencyContact((EmergencyContact) childXMLObject);
        else if(childXMLObject instanceof LEmergencyContact) ppObject.getLEmergencyContacts().add((LEmergencyContact) childXMLObject);
        else if(childXMLObject instanceof Extension) ppObject.setExtension((Extension) childXMLObject);
        else
        {
            log.error("This element does not allow for unknown children.  Please use the Extensions element to extend the object data definition.");
            //ppObject.getUnknownXMLObjects().add(childXMLObject);
        }
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        // NO ELEMENT CONTENT
    }

    
}
