package org.openliberty.xmltooling.pp;

import org.openliberty.xmltooling.dst2_1.LeafAttributes;
import org.opensaml.xmlsec.signature.impl.KeyInfoImpl;

/**
 * Principal's public key or certificate for signing.  This class relies on KeyInfoTypeImpl
 * provided conveniently by the opensaml xml signature library.  But it adds 4 attributes.  
 * <p>
 * NOTE: SignKey adds all of the attributes available through Leaf
 * <p>
 * pp:KeyInfoType
 * 
 * @author asa
 *
 */
public class SignKey extends KeyInfoImpl
{
     
    private LeafAttributes attributes;
    
    public static String LOCAL_NAME = "SignKey";
    
    protected SignKey(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        attributes = new LeafAttributes();
    }

    /**
     * NOTE: "id" is not used even though it is specified in "CommonAttributes" which 
     * is "LeafAttributes" extends
     * 
     * @return a LeafAttributes object
     */
    public LeafAttributes attributes()
    {
        return attributes;
    }
    

}
