package org.openliberty.xmltooling.pp;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.xmlsec.signature.impl.KeyInfoUnmarshaller;
import org.w3c.dom.Attr;

/**
 * Unmarshaller for SignKey, relies on the KeyInfoTypeUnmarshaller defined
 * in the OpenSAML signature library
 * 
 * @author asa
 *
 */
public class SignKeyUnmarshaller extends KeyInfoUnmarshaller
{

    protected SignKeyUnmarshaller()
    {
        // A.H. 2008.12.17 - commented out when upgrading to SAML 2.2.2
        // super(XMLConstants.XMLSIG_NS, SignKey.LOCAL_NAME);
    }

    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        SignKey ppObject = (SignKey) xmlObject;
        if(!ppObject.attributes().processAttribute(attribute, ppObject))
        {
            super.processAttribute(xmlObject, attribute);
        }
    }


}
