package org.openliberty.xmltooling.pp;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.dst2_1.CommonAttributes;
import org.openliberty.xmltooling.pp.dst2_1.ct.IDType;
import org.openliberty.xmltooling.pp.dst2_1.ct.IDValue;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

/**
 * Fiscal identification number
 * <p>
 * If AP chooses to store the VAT attribute, AP MUST implement sufficient permissions 
 * enforcement, policies, audit trail, and usage directives to ensure that the VAT 
 * is only used for legitimate purposes. AP MUST NOT disclose the VAT to
 * inappropriate parties. It is RECOMMENDED that this attribute not be populated.
 * 
 * @author asa
 *
 */
public class VAT extends AbstractSignableXMLObject 
{
    
    public static String LOCAL_NAME = "VAT";
    
    // Attributes
    private CommonAttributes attributes;
    
    // Elements
    private IDValue iDValue;    // REQUIRED
    private IDType iDType;
    private Extension extension;
    
    protected VAT(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        attributes = new CommonAttributes();
    }
    
    public CommonAttributes attributes()
    {
        return attributes;
    }
    
    public void setIDValue(IDValue iDValue) 
    {
        this.iDValue = prepareForAssignment(this.iDValue, iDValue);
    }

    public IDValue getIDValue() 
    { 
        return iDValue; 
    }    
    
    public void setIDType(IDType iDType) 
    {
        this.iDType = prepareForAssignment(this.iDType, iDType);
    }

    public IDType getIDType() 
    { 
        return iDType; 
    }    
    
    public void setExtension(Extension extension) 
    {
        this.extension = prepareForAssignment(this.extension, extension);
    }

    public Extension getExtension() 
    { 
        return extension; 
    }    
    
    
    public List<XMLObject> getOrderedChildren() 
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
                
        children.add(iDValue);        
        children.add(iDType);       
        children.add(extension);  

        return Collections.unmodifiableList(children);
    }   
    
    
}

/* 
<xs:element name="VAT" type="VATType"/>
<xs:complexType name="VATType">
    <xs:sequence>
        <xs:element ref="IDValue"/>
        <xs:element ref="IDType" minOccurs="0"/>
        <xs:element ref="Extension" minOccurs="0"/>
    </xs:sequence>
    <xs:attributeGroup ref="commonAttributes"/>
</xs:complexType>
*/
