package org.openliberty.xmltooling.pp;

import org.apache.log4j.Logger;
import org.openliberty.xmltooling.pp.dst2_1.ct.IDType;
import org.openliberty.xmltooling.pp.dst2_1.ct.IDValue;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

/**
 * Unmarshaller for VAT
 * 
 * @author asa
 *
 */
public class VATUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    private static Logger log = Logger.getLogger(VATUnmarshaller.class);
    
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        VAT ppObject = (VAT) xmlObject;
        ppObject.attributes().processAttribute(attribute, ppObject);
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        VAT ppObject = (VAT) parentXMLObject;        
        
        if(childXMLObject instanceof IDValue) ppObject.setIDValue((IDValue) childXMLObject);
        else if(childXMLObject instanceof IDType) ppObject.setIDType((IDType) childXMLObject);
        else if(childXMLObject instanceof Extension) ppObject.setExtension((Extension) childXMLObject);
        else
        {
            log.error("This element does not allow for unknown children.  Please use the Extensions element to extend the object data definition.");
            //ppObject.getUnknownXMLObjects().add(childXMLObject);
        }
    }

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        // NO ELEMENT CONTENT
    }

    
}
