package org.openliberty.xmltooling.pp.dst2_1;

import java.lang.reflect.Constructor;

import org.openliberty.xmltooling.dst2_1.DSTLocalizedString;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;

/**
 * This is the generic Builder for all of the classes that extend DSTLocalizedString
 * 
 * @author asa
 *
 */
public class DSTLocalizedStringTypeBuilder extends AbstractXMLObjectBuilder<DSTLocalizedString> 
{

    @Override
    public DSTLocalizedString buildObject(String namespaceURI, String localName, String namespacePrefix) 
    {

        // All of the classes are named the same as the elements they represent, otherwise this will fail.  
        try
        {
            Class<?> clazz = Class.forName("org.openliberty.xmltooling.pp."+localName);
            Constructor<?> constructor = clazz.getConstructor(new Class[] {String.class,String.class,String.class });
            return (DSTLocalizedString)constructor.newInstance( new Object[] { namespaceURI, localName, namespacePrefix } );
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
       
        return new DSTLocalizedString(namespaceURI, localName, namespacePrefix);
        
    }

}