package org.openliberty.xmltooling.pp.dst2_1;

import java.lang.reflect.Constructor;

import org.openliberty.xmltooling.dst2_1.DSTString;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;

/**
 * This is the generic Builder for all of the classes that extend DSTString
 * @author asa
 *
 */
public class DSTStringTypeBuilder extends AbstractXMLObjectBuilder<DSTString> 
{

    @Override
    public DSTString buildObject(String namespaceURI, String localName, String namespacePrefix) 
    {

        // All of the classes are named the same as the elements they represent, otherwise this will fail.  
        try
        {
            Class<?> clazz = Class.forName("org.openliberty.xmltooling.pp.dst2_1.ct."+localName);
            Constructor<?> constructor = clazz.getConstructor(new Class[] {String.class,String.class,String.class });
            return (DSTString)constructor.newInstance( new Object[] { namespaceURI, localName, namespacePrefix } );
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        
        /*
        catch (ClassNotFoundException e)
        {
            e.printStackTrace();
        }
        catch (SecurityException e)
        {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e)
        {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e)
        {
            e.printStackTrace();
        }
        catch (InstantiationException e)
        {
            e.printStackTrace();
        }
        catch (IllegalAccessException e)
        {
            e.printStackTrace();
        }
        catch (InvocationTargetException e)
        {
            e.printStackTrace();
        }
        */
        
        return new DSTString(namespaceURI, localName, namespacePrefix);
        
        
        /*
        if(localName.equals(AltCN.LOCAL_NAME))
        {
            return new AltCN(namespaceURI, localName, namespacePrefix);
        }
        else if(localName.equals(AltO.LOCAL_NAME))
        {
            return new AltO(namespaceURI, localName, namespacePrefix);
        }
        else if(localName.equals(C.LOCAL_NAME))
        {
            return new C(namespaceURI, localName, namespacePrefix);
        }
        else if(localName.equals(CN.LOCAL_NAME))
        {
            return new CN(namespaceURI, localName, namespacePrefix);
        }
        
                
        else return null;
        */
    }

}