package org.openliberty.xmltooling.pp.dst2_1;

import java.lang.reflect.Constructor;

import org.openliberty.xmltooling.dst2_1.DSTURI;
import org.opensaml.core.xml.schema.impl.XSURIBuilder;

/**
 * This is the generic Builder for all of the classes that extend DSTString
 * @author asa
 *
 */
public class DSTURITypeBuilder extends XSURIBuilder  //AbstractXMLObjectBuilder<DSTURI> 
{

    @Override
    public DSTURI buildObject(String namespaceURI, String localName, String namespacePrefix) 
    {

        // All of the classes are named the same as the elements they represent, otherwise this will fail.  
        // NOTE: How costly is introspection?
        try
        {
            Class<?> clazz = Class.forName("org.openliberty.xmltooling.pp.dst2_1.ct."+localName);
            Constructor<?> constructor = clazz.getConstructor(new Class[] {String.class,String.class,String.class });
            return (DSTURI)constructor.newInstance( new Object[] { namespaceURI, localName, namespacePrefix } );
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
                
        return new DSTURI(namespaceURI, localName, namespacePrefix);

    }

}