package org.openliberty.xmltooling.pp.dst2_1.ct;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.DSTURI;

/**
 * Defines the role of an AddressCard
 * <p>
 * Following enumerators MUST be supported:
 * 
 * <li>urn:liberty:id-sis-pp:addrType:domicile   -  legal residence
 * <li>urn:liberty:id-sis-pp:addrType:home   - everyday home
 * <li>urn:liberty:id-sis-pp:addrType:work   - work address, the office where the person works
 * <li>urn:liberty:id-sis-pp:addrType:vacation   - holiday address
 * <li>urn:liberty:id-sis-pp:addrType:emergency  - structured emergency contact
 * 
 * @author asa
 *
 */
public class AddrType extends DSTURI
{
    public static String LOCAL_NAME = "AddrType";

    public AddrType()
    {
        super(Konstantz.PP_NS, LOCAL_NAME, Konstantz.PP_PREFIX);
    }
    
    public AddrType(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }


    /**
     * This Enumeration holds the 5 AddressCard AddrTypes shown in 
     * section 2.1.1 of the liberty-idsis-pp-v1.1 reference document
     * in Table 3, Data Availability Discovery Option Keywords and in 
     * section 5.7.1 defining the AddrType element.
     * <p>
     * 
     * @author asa
     *
     */
    public enum Type
    {
        DOMICILE("urn:liberty:id-sis-pp:addrType:domicile"),
        HOME("urn:liberty:id-sis-pp:addrType:home"),
        WORK("urn:liberty:id-sis-pp:addrType:work"),
        VACATION("urn:liberty:id-sis-pp:addrType:vacation"),
        EMERGENCY("urn:liberty:id-sis-pp:addrType:emergency");

        private String queryString;
        private String urn;
        
        private Type(String urn)
        {
            this.urn = urn;
            this.queryString = "/pp:PP/pp:AddressCard [pp:AddrType=\""+urn+"\"]";
        }

        public String urn()
        {
            return urn;
        }
        
        public String queryString()
        {
            return queryString;
        }

        public static Type typeForName(String name)
        {
            if(name!=null)
            {
                for(Type type : values())
                {
                    if(name.equals(type.name())) return type;
                }
            }
            return null;
        }

        public static Type typeForUrn(String urn)
        {
            if(urn!=null)
            {
                for(Type type : values())
                {
                    if(urn.equals(type.urn())) return type;
                }
            }
            return null;
        }
        

    }

}