package org.openliberty.xmltooling.pp.dst2_1.ct;

import org.openliberty.xmltooling.dst2_1.DSTURI;

/**
 * Type of identification number stored in a VAT or AltID attribute
 *
 * <li>urn:liberty:id-sis-pp:IDType:ukvat</li>
 * <li>urn:liberty:id-sis-pp:IDType:itcif</li>
 * <li>urn:liberty:id-sis-pp:IDType:ptnif</li>
 * <li>urn:liberty:id-sis-pp:IDType:esnif</li>
 * <li>urn:liberty:id-sis-pp:IDType:fialv</li>
 * <li>urn:liberty:id-sis-pp:IDType:rfid</li>
 * 
 * @author asa
 *
 */
public class IDType extends DSTURI
{
    public static String LOCAL_NAME = "IDType";
    
    protected IDType(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public enum Type
    {
        UKVAT("urn:liberty:id-sis-pp:IDType:ukvat"),
        ITCIF("urn:liberty:id-sis-pp:IDType:itcif"),
        PTNIF("urn:liberty:id-sis-pp:IDType:ptnif"),
        ESNIF("urn:liberty:id-sis-pp:IDType:esnif"),
        FIALV("urn:liberty:id-sis-pp:IDType:fialv"),
        RFID("urn:liberty:id-sis-pp:IDType:rfid");
        
        String uri;

        Type(String uri)
        {
            this.uri = uri;
        }
        public String uri()
        {
            return uri;
        }
    }
    
    
    
}
