package org.openliberty.xmltooling.pp.dst2_1.ct;

import org.openliberty.xmltooling.dst2_1.DSTURI;

/**
 * Usage role of the messaging contact
 * <p>
 * Following enumerators MUST be supported:
 * <li>urn:liberty:id-sis-pp:msgType:personal
 * <li>urn:liberty:id-sis-pp:msgType:work
 * <li>urn:liberty:id-sis-pp:msgType:mobile
 * <li>urn:liberty:id-sis-pp:msgType:vacation
 * <li>urn:liberty:id-sis-pp:msgType:emergency
 * 
 * @author asa
 *
 */
public class MsgType extends DSTURI
{
    public static String LOCAL_NAME = "MsgType";
    
    protected MsgType(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public enum Type
    {
        PERSONAL("urn:liberty:id-sis-pp:msgType:personal"),
        WORK("urn:liberty:id-sis-pp:msgType:work"),
        MOBILE("urn:liberty:id-sis-pp:msgType:mobile"),
        VACATION("urn:liberty:id-sis-pp:msgType:vacation"),
        EMERGENCY("urn:liberty:id-sis-pp:msgType:emergency");
        
        private String uri;
        
        private Type(String uri)
        {
            this.uri = uri;
        }
        
        public String uri()
        {
            return this.uri;
        }
    }
    
}
