package org.openliberty.xmltooling.pp.subs;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.xml.namespace.QName;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.ref.ItemData;
import org.openliberty.xmltooling.dst2_1.ref.ItemDataMarshaller;
import org.openliberty.xmltooling.dst2_1.ref.ItemDataUnmarshaller;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;

/**
 * 
 * 
 * @author asa
 *
 */
public class PPItemData extends ItemData implements ElementExtensibleXMLObject
{

    public static final String LOCAL_NAME = "ItemData";

    private IndexedXMLObjectChildrenList<XMLObject> unknownXMLObjects;

    public PPItemData()
    {
        super(Konstantz.PP_SUBS_NS, LOCAL_NAME, Konstantz.PP_SUBS_PREFIX);
    }
    
    public PPItemData(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        if(null!=unknownXMLObjects) children.addAll(unknownXMLObjects); 
        return Collections.unmodifiableList(children);
    }

    public List<XMLObject> getUnknownXMLObjects() 
    {       
        if(null==unknownXMLObjects) unknownXMLObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);
        return unknownXMLObjects;
    }

    @SuppressWarnings("unchecked")
    public List<XMLObject> getUnknownXMLObjects(QName typeOrName)
    {
        if(null==unknownXMLObjects) unknownXMLObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);
        return (List<XMLObject>) unknownXMLObjects.subList(typeOrName);
    }

    
    /**
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<PPItemData> 
    {
        @Override
		public PPItemData buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new PPItemData(namespaceURI, localName, namespacePrefix);
        }        
    }
   

    /**
     * Internal Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends ItemDataMarshaller
    {
    }

    /**
     * Internal Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends ItemDataUnmarshaller
    {
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            PPItemData obj = (PPItemData)parentXMLObject;            
            obj.getUnknownXMLObjects().add(childXMLObject);
        }
    }






}
