package org.openliberty.xmltooling.pp.subs;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.subs.NotificationType;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

public class PPNotification extends NotificationType
{
    public static final String LOCAL_NAME = "Notification";
    // Elements
    private XMLObjectChildrenList<PPItemData> itemDatas;
    
    public PPNotification(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    public PPNotification()
    {
        super(Konstantz.PP_SUBS_NS, LOCAL_NAME, Konstantz.PP_SUBS_PREFIX);
    }

    public List<PPItemData> getItemsDatas()
    {
        if(null==itemDatas) itemDatas = new XMLObjectChildrenList<PPItemData>(this);
        return itemDatas;
    }
    
    @Override
	public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        if(null!=itemDatas) children.addAll(itemDatas); 
        return Collections.unmodifiableList(children);
    }
    

    
    /**
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<PPNotification> 
    {
        @Override
		public PPNotification buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new PPNotification(namespaceURI, localName, namespacePrefix);
        }        
    }
   

    /**
     * Internal Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends NotificationType.Marshaller
    {        
    }

    /**
     * Internal Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends NotificationType.Unmarshaller
    {
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            PPNotification obj = (PPNotification)parentXMLObject;            
            if(childXMLObject instanceof PPItemData)
            {
                obj.getItemsDatas().add((PPItemData)childXMLObject);
            }
            else
            {
                super.processChildElement(parentXMLObject, childXMLObject);
            }
        }
    }



    
}
