package org.openliberty.xmltooling.pp.subs;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class PPNotify extends AbstractXMLObject
{

    public static final String LOCAL_NAME = "Notify";

    // Elements
    private XMLObjectChildrenList<PPNotification> notifications;
    
    public PPNotify()
    {
        super(Konstantz.PP_SUBS_NS, LOCAL_NAME, Konstantz.PP_SUBS_PREFIX);
    }

    public List<PPNotification> getNotifications()
    {
        if(null==notifications) notifications = new XMLObjectChildrenList<PPNotification>(this);
        return notifications;
    }
    
    protected PPNotify(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        if(null!=notifications) children.addAll(notifications); 
        return Collections.unmodifiableList(children);
    }
    

    
    /**
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<PPNotify> 
    {
        @Override
		public PPNotify buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new PPNotify(namespaceURI, localName, namespacePrefix);
        }        
    }
   

    /**
     * Internal Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
        }
        
    }

    /**
     * Internal Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            PPNotify obj = (PPNotify)parentXMLObject;
            
            if(childXMLObject instanceof PPNotification)
            {
                obj.getNotifications().add((PPNotification)childXMLObject);
            }
        }

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
        }
    }




    
    
}
