package org.openliberty.xmltooling.pp.subs;

import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.namespace.QName;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.subs.Subscription;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * PP v1 does not define Subscription/Notification, this is a 
 * non specification implementation
 * <pre>
 * &lt;Subscription subscriptionID="subs123" notifyToRef="UUID" includeData="1">
 *      &lt;ResultQuery objectType="entry">
 *          &lt;Select attributes="HELLO"/>
 *      &lt;/ResultQuery>
 *      &lt;RefItem itemIDRef="1"/>
 * &lt;/Subscription>
 * </pre>
 * 
 *  NotifyToRef points to an ApplicationEPR in the SOAP header that is used to notify the 
 *  entity making the subscription request
 *  
 * @author asa
 *
 */
public class PPSubscription extends Subscription
{

    public static final String LOCAL_NAME = "Subscription";

    public static final QName DEFAULT_QNAME = new QName(Konstantz.PP_SUBS_NS, LOCAL_NAME, Konstantz.PP_SUBS_PREFIX);

    /**
     * This is a recognizable name for the user who may want to review subscriptions
     */
    private String subscriberName;

    /**
     * This is an URL/URI representing the subscriber
     */
    private String subscriberURI;

    /**
     * HACK: This is a stand in for a stored EPR referenced by notifyToRef.  The PP relies on
     * transport level security at the moment for profile updates
     */
    private URL notifyToURL;


    public static final String ATT_SUBSCRIBER_NAME = "subscriberName";
    public static final String ATT_SUBSCRIBER_URI = "subscriberURI";
    public static final String ATT_NOTIFY_TO_URL = "notifyToURL";


    public PPSubscription()
    {
        super(Konstantz.PP_SUBS_NS, LOCAL_NAME, Konstantz.PP_SUBS_PREFIX);
    }

    public PPSubscription(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    // Elements

    public String getSubscriberName()
    {
        return subscriberName;
    }

    public void setSubscriberName(String subscriberName)
    {
        this.subscriberName = prepareForAssignment(this.subscriberName, subscriberName);
    }

    public String getSubscriberURI()
    {
        return subscriberURI;
    }

    public void setSubscriberURI(String subscriberURI)
    {
        this.subscriberURI = prepareForAssignment(this.subscriberURI, subscriberURI);
    }

    public URL getNotifyToURL()
    {
        return notifyToURL;
    }

    public void setNotifyToURL(URL notifyToURL)
    {
        this.notifyToURL = prepareForAssignment(this.notifyToURL, notifyToURL);
    }

    /**
     * Internal builder class simplifies the file structure
     * 
     * @author asa
     *
     */
    public static class Builder extends  AbstractXMLObjectBuilder<PPSubscription> 
    {
        @Override
		public PPSubscription buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new PPSubscription(namespaceURI, localName, namespacePrefix);
        }    
    }

    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends org.openliberty.xmltooling.subs.Subscription.Marshaller
    {    
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            PPSubscription subscription = (PPSubscription)xmlObject;
            if(subscription.getSubscriberName() != null)
            {
                domElement.setAttributeNS(null, PPSubscription.ATT_SUBSCRIBER_NAME, subscription.getSubscriberName());
            }

            if(subscription.getSubscriberURI() != null)
            {
                domElement.setAttributeNS(null, PPSubscription.ATT_SUBSCRIBER_URI, subscription.getSubscriberURI());
            }

            if(subscription.getNotifyToURL() != null)
            {
                domElement.setAttributeNS(null, PPSubscription.ATT_NOTIFY_TO_URL, subscription.getNotifyToURL().toString());
            }

            super.marshallAttributes(xmlObject, domElement);
        }
    }

    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends org.openliberty.xmltooling.subs.Subscription.Unmarshaller
    {               
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            PPSubscription subscription = (PPSubscription) xmlObject;
            if (attribute.getLocalName().equals(PPSubscription.ATT_SUBSCRIBER_NAME)) 
            {
                subscription.setSubscriberName(attribute.getValue());
            }
            else if (attribute.getLocalName().equals(PPSubscription.ATT_SUBSCRIBER_NAME)) 
            {
                subscription.setSubscriberURI(attribute.getValue());
            }
            else if (attribute.getLocalName().equals(PPSubscription.ATT_NOTIFY_TO_URL)) 
            {
                try
                {
                    subscription.setNotifyToURL(new URL( attribute.getValue() ));
                }
                catch (MalformedURLException e)
                {
                    e.printStackTrace();
                }
            }
            else
            {
                super.processAttribute(xmlObject, attribute);
            }
        }
    }




}
