package org.openliberty.xmltooling.ps;

import java.util.List;

import net.shibboleth.utilities.java.support.xml.ElementSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * The &lt;DisplayName&gt; element provides a human-readable friendly name for Objects.
 * <br />
 * <pre>
 *     &lt;xs:complexType name="LocalizedDisplayNameType"&gt;
 *         &lt;xs:simpleContent&gt;
 *             &lt;xs:extension base="xs:string"&gt;
 *                 &lt;xs:attribute name="Locale" type="xs:language" use="required"/&gt;
 *                 &lt;xs:attribute name="IsDefault" type="xs:boolean" use="optional"/&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:simpleContent&gt;        
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class DisplayName extends AbstractXMLObject
{
    
	public static String LOCAL_NAME = "DisplayName";

	public static String DEFAULT_LOCALE = "en";
	
	// ATTRIBUTE NAMES
    public static String ATT_LOCALE = "Locale";			// required  xs:language  "en"
    public static String ATT_IS_DEFAULT = "IsDefault";	// optional Boolean
    
    // ATTRIBUTES
    public String locale;
    public String isDefault;
    
	private String value;
    
    public DisplayName(String value, String locale)
    {
        super(Konstantz.PS_NS, DisplayName.LOCAL_NAME, Konstantz.PS_PREFIX);
        this.value = value;
        this.locale = null==locale?DEFAULT_LOCALE:locale;
    }
    
	protected DisplayName(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);
	}
	
    public void setLocale(String locale) 
    {
    	this.locale = prepareForAssignment(this.locale, locale);
    }
    
    public String getLocale() 
    { 
    	return locale; 
    }

    public boolean isDefault()
    {
    	return (null!=isDefault && (isDefault.toLowerCase().equals("true") || isDefault.toLowerCase().equals("t") || isDefault.toLowerCase().equals("1")));
    }
    
    public void setIsDefault(String isDefault) 
    {
    	this.isDefault = prepareForAssignment(this.isDefault, isDefault);
    }
    
    public String getIsDefault() 
    { 
    	return isDefault; 
    }
	
    public void setValue(String value) 
    {
    	this.value = prepareForAssignment(this.value, value);
    }
    
    public String getValue() 
    { 
    	return value; 
    }

	public List<XMLObject> getOrderedChildren() 
	{
		return null;
	}
	
    
    public static class Builder extends AbstractXMLObjectBuilder<DisplayName> 
    {
        @Override
		public DisplayName buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new DisplayName(namespaceURI, localName, namespacePrefix);
        }   
    }
    
    
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {
        
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            DisplayName displayName = (DisplayName)xmlObject;

            if(displayName.getIsDefault() != null) 
            {
                domElement.setAttributeNS(null, DisplayName.ATT_IS_DEFAULT , displayName.getIsDefault());
            }
            
            if(displayName.getLocale() != null) 
            {
                domElement.setAttributeNS(null, DisplayName.ATT_LOCALE , displayName.getLocale());
            }

        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            ElementSupport.appendTextContent(domElement, ((DisplayName)xmlObject).getValue());       
        }

    }

    
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {        
        
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            DisplayName o = (DisplayName) xmlObject;
            
            String localName = attribute.getLocalName();
            
            if (localName.equals(DisplayName.ATT_IS_DEFAULT)) 
            {
                o.setIsDefault(attribute.getValue());
            }
            else if (localName.equals(DisplayName.ATT_LOCALE)) 
            {
                o.setLocale(attribute.getValue());
            }

        }   
        
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {   
            // NO Child Elements 
        }

        
        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            ((DisplayName) xmlObject).setValue(elementContent);
        }

    }
    
    
}
