package org.openliberty.xmltooling.ps;

import org.openliberty.xmltooling.ps.request.AddCollectionRequest;
import org.openliberty.xmltooling.ps.request.AddEntityRequest;
import org.openliberty.xmltooling.ps.request.AddKnownEntityRequest;
import org.openliberty.xmltooling.ps.request.AddToCollectionRequest;
import org.openliberty.xmltooling.ps.request.GetObjectInfoRequest;
import org.openliberty.xmltooling.ps.request.ListMembersRequest;
import org.openliberty.xmltooling.ps.request.QueryObjectsRequest;
import org.openliberty.xmltooling.ps.request.RemoveCollectionRequest;
import org.openliberty.xmltooling.ps.request.RemoveEntityRequest;
import org.openliberty.xmltooling.ps.request.RemoveFromCollectionRequest;
import org.openliberty.xmltooling.ps.request.ResolveIdentifierRequest;
import org.openliberty.xmltooling.ps.request.SetObjectInfoRequest;
import org.openliberty.xmltooling.ps.request.TestMembershipRequest;
import org.openliberty.xmltooling.ps.response.AddCollectionResponse;
import org.openliberty.xmltooling.ps.response.AddEntityResponse;
import org.openliberty.xmltooling.ps.response.AddKnownEntityResponse;
import org.openliberty.xmltooling.ps.response.AddToCollectionResponse;
import org.openliberty.xmltooling.ps.response.GetObjectInfoResponse;
import org.openliberty.xmltooling.ps.response.ListMembersResponse;
import org.openliberty.xmltooling.ps.response.QueryObjectsResponse;
import org.openliberty.xmltooling.ps.response.RemoveCollectionResponse;
import org.openliberty.xmltooling.ps.response.RemoveEntityResponse;
import org.openliberty.xmltooling.ps.response.RemoveFromCollectionResponse;
import org.openliberty.xmltooling.ps.response.ResolveIdentifierResponse;
import org.openliberty.xmltooling.ps.response.SetObjectInfoResponse;
import org.openliberty.xmltooling.ps.response.TestMembershipResponse;

public class Konstantz 
{
	/**
	 * This enumeration stores the action URI and references to each request and response class involved
	 * in a PS request response loop
	 * 
	 * @author asa
	 *
	 */
	public static enum PeopleServiceRequestType 
	{
		ADD_ENTITY_REQUEST ( "urn:liberty:ps:2006-08:AddEntityRequest", AddEntityRequest.class, AddEntityResponse.class ),
		ADD_KNOWN_ENTITY_REQUEST ( "urn:liberty:ps:2006-08:AddKnownEntityRequest", AddKnownEntityRequest.class, AddKnownEntityResponse.class ),
		REMOVE_ENTITY_REQUEST ( "urn:liberty:ps:2006-08:RemoveEntityRequest", RemoveEntityRequest.class, RemoveEntityResponse.class ),
		ADD_COLLECTION_REQUEST ( "urn:liberty:ps:2006-08:AddCollectionRequest", AddCollectionRequest.class, AddCollectionResponse.class ),
		REMOVE_COLLECTION_REQUEST ( "urn:liberty:ps:2006-08:RemoveCollectionRequest", RemoveCollectionRequest.class, RemoveCollectionResponse.class ),
		ADD_TO_COLLECTION_REQUEST ( "urn:liberty:ps:2006-08:AddToCollectionRequest", AddToCollectionRequest.class, AddToCollectionResponse.class ),
		REMOVE_FROM_COLLECTION_REQUEST ( "urn:liberty:ps:2006-08:RemoveFromCollectionRequest", RemoveFromCollectionRequest.class, RemoveFromCollectionResponse.class ),
		LIST_MEMBERS_REQUEST ( "urn:liberty:ps:2006-08:ListMembersRequest", ListMembersRequest.class, ListMembersResponse.class ),
		GET_OBJECT_INFO_REQUEST ( "urn:liberty:ps:2006-08:GetObjectInfoRequest", GetObjectInfoRequest.class, GetObjectInfoResponse.class ),
		SET_OBJECT_INFO_REQUEST ( "urn:liberty:ps:2006-08:SetObjectInfoRequest", SetObjectInfoRequest.class, SetObjectInfoResponse.class ),
		QUERY_OBJS_REQUEST ( "urn:liberty:ps:2006-08:QueryObjectsRequest", QueryObjectsRequest.class, QueryObjectsResponse.class ),
		TEST_MEMBERSHIP_REQUEST ( "urn:liberty:ps:2006-08:TestMembershipRequest", TestMembershipRequest.class, TestMembershipResponse.class ),
		RESOLVE_ID_REQUEST ( "urn:liberty:ps:2006-08:ResolveIdentiferRequest", ResolveIdentifierRequest.class, ResolveIdentifierResponse.class ); //,
		// NOTIFY_REQUEST ( "urn:liberty:ps:2006-08:Notify", Notify );

		private final String actionURI;
		private final Class<?> requestClass;
		private final Class<?> responseClass;

		PeopleServiceRequestType(String actionURI, Class<?> requestClass, Class<?> responseClass) 
		{
			this.actionURI = actionURI;
			this.requestClass = requestClass;
			this.responseClass = responseClass;
		}

		public String actionURI()   { return actionURI; }
		public Class<?> responseClass() { return responseClass; }
	
		public static PeopleServiceRequestType typeForClass(Class<?> aClass)
		{
			for(PeopleServiceRequestType type : values())
			{
				if(type.requestClass==aClass) return type;
			}
			
			return null;
		}
	}
	
	
}
