package org.openliberty.xmltooling.ps;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.schema.impl.XSURIImpl;
import org.opensaml.core.xml.schema.impl.XSURIMarshaller;
import org.opensaml.core.xml.schema.impl.XSURIUnmarshaller;

/**
 * The &lt;ObjectID&gt; element is defined so that the PS provider can scope each member's identifier locally and uniquely.
 * <p>
 * <pre>
 * &lt;!-- Declaration of ObjectID element --&gt;
 * &lt;xs:element name="ObjectID" type="ObjectIDType"/&gt;
 * &lt;!-- Definition of ObjectIDType --&gt;
 * &lt;xs:complexType name="ObjectIDType"&gt;
 *   &lt;xs:simpleContent&gt;
 *     &lt;xs:restriction base="xs:anyURI"/&gt;
 *   &lt;/xs:simpleContent&gt;
 * &lt;/xs:complexType&gt;
 * </pre>
 * </p>
 * <p> 
 * Where privacy is a concern, PS providers MUST ensure that ObjectID's do not create a privacy concern by allowing
 * different WSCs to make inappropriate correlations about the users for which the Object identifiers stand. Unique
 * identifiers for different WSCs (e.g. pairwise identifiers) and encrypted identifiers are potential mechanisms for
 * addressing this concern.
 * </p>
 * @author asa
 *
 */
public class ObjectID extends XSURIImpl
{

	public static String LOCAL_NAME = "ObjectID";	
	
    public ObjectID()
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
    }
        
    public ObjectID(String value)
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        this.setValue(value);
    }
    
	protected ObjectID(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);
	}
    
    /**
     * Static Builder class
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<ObjectID> 
    {

        @Override
		public ObjectID buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new ObjectID(namespaceURI, localName, namespacePrefix);
        }
        
    }
    
    /**
     * Static Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends XSURIMarshaller
    {
    }
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends XSURIUnmarshaller
    {            
    }
    
    
}