package org.openliberty.xmltooling.ps;

import java.util.List;

import net.shibboleth.utilities.java.support.xml.ElementSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * The &lt;ObjectRef&gt; element is used as a pointer to an &lt;Object&gt; through that &lt;Object&gt;'s &lt;ObjectID&gt; element.
 * <p>
 * The &lt;ObjectRef&gt; element allows an &lt;Object&gt; element to be included in another by reference rather than directly.
 * For instance, the fact that a given user belongs to different groups can be represented by both those groups' &lt;Object&gt;
 * element containing an &lt;ObjectRef&gt; element that refers to that user's &lt;Object&gt; element.
 * 
 * @author asa
 *
 */
public class ObjectRef extends AbstractXMLObject
{

	public static String LOCAL_NAME = "ObjectRef";	
	
	private String value;
    
    public ObjectRef()
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
    }
    
	protected ObjectRef(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);
	}
	
    public void setValue(String value) 
    {
    	this.value = prepareForAssignment(this.value, value);
    }
    
    public String getValue() 
    { 
    	return value; 
    }

	public List<XMLObject> getOrderedChildren() 
	{
		return null;
	}

    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<ObjectRef> 
    {

        @Override
		public ObjectRef buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new ObjectRef(namespaceURI, localName, namespacePrefix);
        }
        
    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {
               
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            // NO ATTS
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            ElementSupport.appendTextContent(domElement, ((ObjectRef)xmlObject).getValue());       
        }

    }

    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {
            
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            // NO ATTS
        }   
        
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {   
            // NO Child Elements 
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            ((ObjectRef) xmlObject).setValue(elementContent);
        }

    }
    
}