package org.openliberty.xmltooling.ps;

import java.util.List;

import net.shibboleth.utilities.java.support.xml.ElementSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * The &lt;Tag&gt; element allows users to add their own metadata to &lt;Object&gt; elements. For instance, a user might add a
 * &lt;Tag&gt; element with a value of 'sports' for the Ref attribute to a group Object called 'Team' to denote the theme of
 * that group (perhaps to distinguish it from another group with the same name for some work project).
 * <p>
 * <pre>
 * &lt;xs:complexType name="TagType"&gt;
 *   &lt;xs:attribute name="Ref" type="xs:anyURI" use="required"/&gt;
 * &lt;/xs:complexType&gt;
 * </pre>
 * </p>
 * <p>
 * The value of the Ref attribute SHOULD be a tag space (a place that collates or defines tags), where the last component
 * of the URL is the tag. For instance, http://technorati.com/tag/music is a URL for the tag "music."
 * </p>
 * 
 * @author asa
 *
 */
public class Tag extends AbstractXMLObject
{

	public static String LOCAL_NAME = "Tag";	

	// ATTRIBUTE NAME
    public static String ATT_REF = "Ref";			// required  xs:anyURI

    // ATTRIBUTES
    public String ref;

	private String value;
    
    
    public Tag(String value, String ref)
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        this.value = value;
        this.ref = ref;
    }
    
	protected Tag(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);
	}

	
    public void setValue(String value) 
    {
    	this.value = prepareForAssignment(this.value, value);
    }
    
    public String getValue() 
    { 
    	return value; 
    }

    public void setRef(String ref) 
    {
    	this.ref = prepareForAssignment(this.ref, ref);
    }
    
    public String getRef() 
    { 
    	return ref; 
    }

    public List<XMLObject> getOrderedChildren() 
    {
    	return null;
    }

    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<Tag> 
    {

        @Override
		public Tag buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new Tag(namespaceURI, localName, namespacePrefix);
        }
        
    }
    
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            Tag tag = (Tag)xmlObject;

            if(tag.getRef() != null) 
            {
                domElement.setAttributeNS(null, Tag.ATT_REF , tag.getRef());
            }

        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            ElementSupport.appendTextContent(domElement, ((Tag)xmlObject).getValue());       
        }

    }

    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {        
        
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            Tag o = (Tag) xmlObject;
                    
            if (attribute.getLocalName().equals(Tag.ATT_REF)) 
            {
                o.setRef(attribute.getValue());
            }

        }   
        
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {   
            // NO Child Elements 
        }
        
        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            ((Tag) xmlObject).setValue(elementContent);
        }

    }
    
}
