package org.openliberty.xmltooling.ps;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.schema.impl.XSURIImpl;
import org.opensaml.core.xml.schema.impl.XSURIMarshaller;
import org.opensaml.core.xml.schema.impl.XSURIUnmarshaller;

/**
 * 
 * @author asa
 *
 */
public class TargetObjectID extends XSURIImpl
{

	public static String LOCAL_NAME = "TargetObjectID";	
	    
    public TargetObjectID()
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
    }
    
    public TargetObjectID(String value)
    {
        super(Konstantz.PS_NS, LOCAL_NAME, Konstantz.PS_PREFIX);
        this.setValue(value);
    }
    
	protected TargetObjectID(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);
	}

    /**
     * Static Builder
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<TargetObjectID> 
    {

        @Override
		public TargetObjectID buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new TargetObjectID(namespaceURI, localName, namespacePrefix);
        }
        
    }
    
    /**
     * Static Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends XSURIMarshaller
    {
    }
    
    /**
     * Static Unmarshaller
     * @author asa
     *
     */
    public static class Unmarshaller extends XSURIUnmarshaller
    {
    }
    
}